/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm.h"

/* error is only valid until next call to this function. */

GM_ENTRY_POINT
char *gm_strerror (gm_status_t error)
{
  switch (error)
    {
    case GM_SUCCESS:
      return  "success";
    case GM_FAILURE:
      return  "unqualified error";
    case GM_INPUT_BUFFER_TOO_SMALL:
      return  "input buffer is too small";
    case GM_OUTPUT_BUFFER_TOO_SMALL:
      return  "output buffer is too small";
    case GM_TRY_AGAIN:
      return  "try again";
    case GM_BUSY:
      return  "busy";
    case GM_MEMORY_FAULT:
      return  "memory fault";
    case GM_INTERRUPTED:
      return  "interrupted";
    case GM_INVALID_PARAMETER:
      return  "invalid parameter";
    case GM_OUT_OF_MEMORY:
      return  "out of memory";
    case GM_INVALID_COMMAND:
      return  "invalid command";
    case GM_PERMISSION_DENIED:
      return  "permission denied";
    case GM_INTERNAL_ERROR:
      return  "internal error";
    case GM_UNATTACHED:
      return  "unattached";
    case GM_UNSUPPORTED_DEVICE:
      return  "unsupported device";
    case GM_SEND_TIMED_OUT:
      return  "send timed out";
    case GM_SEND_REJECTED:
      return  "send was rejected by receiver";
    case GM_SEND_TARGET_PORT_CLOSED:
      return  "target port was closed";
    case GM_SEND_TARGET_NODE_UNREACHABLE:
      return  "target node was unreachable";
    case GM_SEND_DROPPED:
      return  "send dropped as requested by the client";
    case GM_SEND_PORT_CLOSED:
      return  "send port was closed";
    case GM_NODE_ID_NOT_YET_SET:
      return 
	"node ID not set (node has not been configured by the mapper)";
    case GM_STILL_SHUTTING_DOWN:
      return 
	"port is still shutting down from previous open";
    case GM_CLONE_BUSY:
      return  "clone device is busy";
    default:
      ;
    }
  return "unknown error";
}

