#include "gm_internal.h"

#if GM_KERNEL && !GM_OS_VXWORKS
#else

#ifdef WIN32

#else
extern int sleep (unsigned int seconds);
#endif

GM_ENTRY_POINT int
gm_sleep (unsigned int seconds)
{
#ifdef WIN32
  static HANDLE hevent = INVALID_HANDLE_VALUE;

  if (hevent == INVALID_HANDLE_VALUE)
    hevent = CreateEvent (NULL, 0, 0, NULL);
  if (hevent == INVALID_HANDLE_VALUE)
    {
      gm_printf ("Whoops: Could not create GM timer.\n");
      exit (1);
    }

  /* Don't set the timer; just wait for it. The API is simpler */

  WaitForSingleObject (hevent, 1000 * (DWORD) seconds);

  return 0; /* sleep() does not return a useful value */


#elif GM_OS_VXWORKS
#include <time.h>

  taskDelay(CLOCKS_PER_SEC * seconds);
  return (0);
#else
  return sleep (seconds);
#endif

}
#endif
