/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_enable_fast_small_send.h"
#include "gm_enable_galvantech_workaround.h"
#include "gm_send_queue.h"

#define GM_DEBUG_SEND_TO_PEER 0

/* Special case for sending to the same port. */
GM_ENTRY_POINT
void
gm_send_to_peer_with_callback (gm_port_t * p, void *message, unsigned int size,
			       gm_size_t len, unsigned int priority,
			       unsigned int target_node_id,
			       gm_send_completion_callback_t callback,
			       void *context)
{
  gm_assert (message);
  gm_assert (gm_min_size_for_length (len) <= size);
  /* gm_assert (GM_MIN_PRIORITY <= priority); */
  gm_assert (priority == GM_LOW_PRIORITY ||
	       priority == GM_HIGH_PRIORITY);
  gm_assert (size >= GM_MIN_MESSAGE_SIZE && size <= 32);
  
#if GM_DEBUG_SEND_TO_PEER
  gm_printf ("gm_send_to_peer_with_callback"
	     " (%p, %p, %d, 0x%lx, %s, %d, %p, %p) called.\n",
	     p, message, size, len,
	     priority ? "GM_HIGH_PRIORITY" : "GM_LOW_PRIORITY",
	     target_node_id, callback, context);
#if 0
  {
    unsigned int i;
    for (i=0; i<len; i++)
      {
	gm_printf ("%02x", ((gm_s8_t *) message)[i]);
	if ((i & 0x7) == 0x7)
	  gm_printf ("\n");
	else if ((i & 0x3) == 0x3)
	  gm_printf (" ");
      }
    if ((i & 0x7) != 0x7)
      gm_printf ("\n");
  }
#endif
#endif

  /* Pass send token to LANai.  Care must be taken to flush the message to
     memory before flushing the token, and the token should be flushed to
     memory immediately. */
  if (len < 256)
    {
#if GM_DEBUG_BUFFERS
      {
	struct gm_buf_handle *bh = gm_find_buf (message);
	if (!bh) {
	  fprintf (stderr, "gm_send_to_peer: got unregistered buffer %p\n",
		   message);
	  abort();
	}
	if (bh->size != -1 && bh->size != (int) size) {
	  fprintf (stderr,
		   "gm_send_to_peer: buffer %p initialized with size %d,\n"
		   "                 arrived with size %d\n",
		   message, bh->size, size);
	  abort();
	}
	if (bh->status != gm_in_app) {
	  fprintf (stderr,
		   "gm_send_to_peer: buffer %p should have status %s not %s\n",
		   message,
		   gm_get_buf_status_name(gm_in_app),
		   gm_get_buf_status_name(bh->status));
	  abort();
	}
	bh->status = gm_in_send;
      }
#endif /* GM_DEBUG_BUFFERS */

      {
	struct gm_fast_send_send_event volatile *se;
	struct gm_fast_send_send_event batch_write;

	se = GM_SEND_QUEUE_SLOT (p, callback, context, fast_send);
	gm_assert (gm_ntoh_u8 (se->type) == 0);

	if (GM_STRUCT_WRITE_COMBINING)
	  {
#if GM_ENABLE_GALVANTECH_WORKAROUND
	    batch_write.ip_checksum
	      = gm_htons (_gm_ip_checksum (message, len));
#endif
	    batch_write.message = gm_hton_up ((gm_up_t) message);
	    batch_write.target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
	    batch_write.length = gm_hton_u8 ((gm_u8_t) len);
	    batch_write.type
	      = gm_hton_u8 ((gm_u8_t) (GM_FAST_SEND_EVENT_0 +
				       GM_PRIORITY_SIZE (priority, size)));
	    if (GM_FAST_SMALL_SEND && len <= GM_FAST_SEND_LEN)
	      {
		unsigned int i;
		volatile gm_ptr_t *data;
		
		data = (volatile gm_ptr_t *) &se->message;
		data -= len / sizeof (gm_ptr_t);
		for (i=0; i<len/GM_SIZEOF_VOID_P; i++)
		  {
		    data[i] = ((gm_ptr_t *) message)[i];
		  }
	      }

	    GM_COPY_TO_IO_SPACE (*se, batch_write);
	  }
	else
	  {
#if GM_ENABLE_GALVANTECH_WORKAROUND
	    se->ip_checksum = gm_htons (_gm_ip_checksum (message, len));
#endif
	    se->message = gm_hton_up ((gm_up_t) message);
	    se->target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
	    se->length = gm_hton_u8 ((gm_u8_t) len);
	    GM_STBAR ();
	    se->type
	      = gm_hton_u8 ((gm_u8_t) (GM_FAST_SEND_EVENT_0 +
				       GM_PRIORITY_SIZE (priority, size)));
	  }

	GM_FLUSH_SEND_EVENT (p, se);
      }
    }
  else
    gm_send_with_callback (p, message, size, len, priority, target_node_id,
			   p->id, callback, context);

}

GM_ENTRY_POINT
void
gm_send_to_peer (gm_port_t * p, void *message, unsigned int size,
		 gm_size_t len, unsigned int priority,
		 unsigned int target_node_id)
{
  gm_send_to_peer_with_callback (p, message, size, len, priority,
				 target_node_id, _gm_sent, message);
}
