/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#if GM_KERNEL

#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_enable_trace.h"
#include "gm_trace.h"
void gm_save_trace(struct gm_port *port)
{
  GM_PARAMETER_MAY_BE_UNUSED (port);
}

#else  /* !GM_KERNEL */

#include <stdio.h>
#include <errno.h>

#include "gm_debug.h"
#include "gm_enable_trace.h"
#include "gm_internal.h"
#include "gm_trace.h"



#if GM_ENABLE_TRACE

static void
gm_save_trace_files(struct gm_port *port, const char *lanai,const char*host)
{
  gm_lanai_globals_t *ptr;
  int len;
  int i;
  FILE *out;
  int index;
  
  /* do lanai stuff */
  GM_PRINT (GM_PRINT_LEVEL >= 2,("saving lanai traces to %s,%s\n",lanai,host));
  len = sizeof(gm_lanai_globals_t)+port->max_node_id*sizeof(struct gm_connection);
  ptr = gm_malloc(sizeof(gm_lanai_globals_t)+port->max_node_id*sizeof(struct gm_connection));
  if (_gm_get_globals(port,(gm_u8_t*)ptr,len) != GM_SUCCESS)
    GM_PANIC (("cannot get globals\n"));

  index = gm_ntoh_u32(ptr->trace_index);
  GM_INFO (("%d trace events\n",index));
  out = fopen(lanai,"w");
  if (!out)
    GM_PANIC (("cannot open file %s: %s\n",lanai,strerror(errno)));
  for (i=0;i<index;i++) 
    {
      gm_file_trace_t rec;
      gm_l_trace_t *l;
      l = ptr->trace_log+i;
      rec.stamp = gm_ntohl(l->stamp);
      rec.evt = gm_ntohl(l->evt);
      rec.aux1 = 0;
      rec.aux2 = 0;
      //    rec.evt2 = gm_ntohl(l->dispatch);
      if (fwrite(&rec,sizeof(rec),1,out) != 1)
	GM_PANIC (("cannot write into file:%s\n",strerror(errno)));
    }
  
  if (fclose(out) != 0)
    GM_PANIC (("closing %s",lanai));

  /* do host stuff */
  out = fopen(host,"w");
  if (!out)
    GM_PANIC (("cannot open file %s: %s\n",host,strerror(errno)));
  for (i=1;i<gm_trace_index;i++) 
    {
      if (fwrite(&gm_trace_log[i],sizeof(gm_trace_log[i]),1,out) != 1)
	GM_PANIC (("cannot write into file:%s\n",strerror(errno)));
    }
  if (fclose(out) != 0)
    GM_PANIC (("closing %s",host));
  
  free(ptr);
}
#endif /* GM_ENABLE_TRACE */

void gm_save_trace(struct gm_port *port)
{
#if GM_ENABLE_TRACE
  char lanai[100];
  char host[100];
  sprintf(lanai,"ltrace_%d",port->this_node_id);
  sprintf(host,"htrace_%d",port->this_node_id);
  gm_save_trace_files(port,lanai,host);
#else
  GM_PARAMETER_MAY_BE_UNUSED (port);
#endif
}

#endif /* !GM_KERNEL */

