/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

/* Check if a receive is pending. */
GM_ENTRY_POINT
int
gm_receive_pending (gm_port_t *p)
{
  int ret;

  ret = (gm_ntoh_u8 (p->recv_queue_slot->event.recv.type) >= 128);
#if !GM_CPU_x86 && !GM_CPU_sparc
  if (!ret)
    {
#if defined WIN32
      /* recv queue should not need updating. */
#elif GM_KERNEL
      GM_ARCH_RECV_QUEUE_UPDATE (p);
#elif 0
      gm_u32_t slot_num = p->recv_queue_slot - p->recv_queue_start;
      _gm_user_ioctl (p, GM_RECV_QUEUE_UPDATE, &slot_num,
		      sizeof (slot_num));
#endif
      ret = (gm_ntoh_u8 (p->recv_queue_slot->event.recv.type) >= 128);
    }
#endif
  return ret;
}

