/*******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

/* This module computes a random number less than a bound. */

#include "gm_internal.h"

GM_ENTRY_POINT unsigned int
gm_rand_mod (unsigned int a)
{
  unsigned int ret;
  unsigned int mask;

  mask = (1 << gm_log2_roundup (a + 1)) - 1;
  do
    ret = gm_rand () & mask;
  while (ret == 0 || ret > a);	/* < 1 retry needed, on average */
  return ret - 1;
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
