/*******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

/* This module implements a poor random number generator. */

#include "gm_internal.h"

static gm_u32_t _gm_rand_seed;

GM_ENTRY_POINT int
gm_rand ()
{
  _gm_rand_seed = (gm_u32_t) gm_crc (&_gm_rand_seed, 4);
  return (int) _gm_rand_seed;
}

GM_ENTRY_POINT void
gm_srand (int seed)
{
  _gm_rand_seed = seed ? seed : 1;
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
