/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_debug_recv_tokens.h"
#include "gm_internal.h"
#include "gm_send_queue.h"

#define GM_DEBUG_PROVIDE_RECEIVE_BUFFER 0

unsigned int gm_debug_recv_token_cnt[GM_NUM_PRIORITIES][GM_NUM_SIZES];

/* After a bounded delay after receiving a message, the buffer used for the
   receive must be replaced by calling this function.  */
GM_ENTRY_POINT
void
gm_provide_receive_buffer_with_tag (gm_port_t * p, void *ptr, unsigned size,
				    unsigned priority, unsigned int tag)
{
  struct gm_host_recv_token volatile *hrt;
  struct gm_host_recv_token batch_write;

  GM_PRINT
    (GM_DEBUG_PROVIDE_RECEIVE_BUFFER,
     ("gm_provide_receive_buffer_with_tag (%p, %p, %d, %d, %d) called\n",
      p, ptr, size, priority, tag));

  gm_assert (size >= GM_MIN_MESSAGE_SIZE && size < GM_NUM_SIZES);
  gm_assert (p);
  gm_assert (ptr);
  gm_assert (priority == GM_LOW_PRIORITY ||
	       priority == GM_HIGH_PRIORITY);

#if GM_DEBUG_RECV_TOKENS
  ++gm_debug_recv_token_cnt[priority][size];
  GM_PRINT (GM_DEBUG_RECV_TOKENS, ("recv_token_cnt:\n"));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("                     1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3\n"));
  
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     (" 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1\n"));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("----------------------------------------------------------------\n"));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x",
	      gm_debug_recv_token_cnt[0][ 0], gm_debug_recv_token_cnt[0][ 1],
	      gm_debug_recv_token_cnt[0][ 2], gm_debug_recv_token_cnt[0][ 3],
	      gm_debug_recv_token_cnt[0][ 4], gm_debug_recv_token_cnt[0][ 5],
	      gm_debug_recv_token_cnt[0][ 6], gm_debug_recv_token_cnt[0][ 7],
	      gm_debug_recv_token_cnt[0][ 8], gm_debug_recv_token_cnt[0][ 9],
	      gm_debug_recv_token_cnt[0][10], gm_debug_recv_token_cnt[0][11],
	      gm_debug_recv_token_cnt[0][12], gm_debug_recv_token_cnt[0][13],
	      gm_debug_recv_token_cnt[0][14], gm_debug_recv_token_cnt[0][15]));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x\n",
	      gm_debug_recv_token_cnt[0][16], gm_debug_recv_token_cnt[0][17],
	      gm_debug_recv_token_cnt[0][18], gm_debug_recv_token_cnt[0][19],
	      gm_debug_recv_token_cnt[0][20], gm_debug_recv_token_cnt[0][21],
	      gm_debug_recv_token_cnt[0][22], gm_debug_recv_token_cnt[0][23],
	      gm_debug_recv_token_cnt[0][24], gm_debug_recv_token_cnt[0][25],
	      gm_debug_recv_token_cnt[0][26], gm_debug_recv_token_cnt[0][27],
	      gm_debug_recv_token_cnt[0][28], gm_debug_recv_token_cnt[0][29],
	      gm_debug_recv_token_cnt[0][30], gm_debug_recv_token_cnt[0][31]));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x",
	      gm_debug_recv_token_cnt[1][ 0], gm_debug_recv_token_cnt[1][ 1],
	      gm_debug_recv_token_cnt[1][ 2], gm_debug_recv_token_cnt[1][ 3],
	      gm_debug_recv_token_cnt[1][ 4], gm_debug_recv_token_cnt[1][ 5],
	      gm_debug_recv_token_cnt[1][ 6], gm_debug_recv_token_cnt[1][ 7],
	      gm_debug_recv_token_cnt[1][ 8], gm_debug_recv_token_cnt[1][ 9],
	      gm_debug_recv_token_cnt[1][10], gm_debug_recv_token_cnt[1][11],
	      gm_debug_recv_token_cnt[1][12], gm_debug_recv_token_cnt[1][13],
	      gm_debug_recv_token_cnt[1][14], gm_debug_recv_token_cnt[1][15]));
  _GM_PRINT (GM_DEBUG_RECV_TOKENS,
	     ("%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x\n",
	      gm_debug_recv_token_cnt[1][16], gm_debug_recv_token_cnt[1][17],
	      gm_debug_recv_token_cnt[1][18], gm_debug_recv_token_cnt[1][19],
	      gm_debug_recv_token_cnt[1][20], gm_debug_recv_token_cnt[1][21],
	      gm_debug_recv_token_cnt[1][22], gm_debug_recv_token_cnt[1][23],
	      gm_debug_recv_token_cnt[1][24], gm_debug_recv_token_cnt[1][25],
	      gm_debug_recv_token_cnt[1][26], gm_debug_recv_token_cnt[1][27],
	      gm_debug_recv_token_cnt[1][28], gm_debug_recv_token_cnt[1][29],
	      gm_debug_recv_token_cnt[1][30], gm_debug_recv_token_cnt[1][31]));
#endif

#if GM_DEBUG_BUFFERS
  if (p != (void *)1) {
    struct gm_buf_handle *bh = gm_find_buf (ptr);
    if (!bh) {
      fprintf (stderr, "gm_provide_receive_buffer: got unregistered "
	       "buffer %p\n", ptr);
      abort();
    }
    if (bh->size != -1 && bh->size != (int) size) {
      fprintf (stderr,
	       "gm_provide_receive_buffer: buffer %p initialized with size "
	       "%d, arrived with size %d\n", ptr, bh->size, size);
      abort();
    }
    if (bh->status != gm_in_app) {
      fprintf (stderr,
	       "gm_provide_receive_buffer: buffer %p should have status "
	       "%s not %s\n", ptr, gm_get_buf_status_name(gm_in_app),
	       gm_get_buf_status_name(bh->status));
      abort();
    }
    bh->status = gm_in_recv;
  }
#endif /* GM_DEBUG_BUFFERS */

  hrt = p->recv_token_queue_slot;

  /* Pass the recv token to the LANai */

  gm_assert (!gm_ntoh_u8 (hrt->ready));
  if (GM_STRUCT_WRITE_COMBINING)
    {
      batch_write.message = gm_hton_up ((gm_up_t) ptr);
      batch_write.tag = gm_hton_u8 ((gm_u8_t) tag);
      batch_write.priority = gm_hton_u8 ((gm_u8_t) priority);
      batch_write.size = gm_hton_u8 ((gm_u8_t) size);
      batch_write.ready = gm_hton_u8 (1);
      /* we transfer bit of unused data in the worst case, FIXME?? */
      GM_COPY_TO_IO_SPACE (*hrt, batch_write);
    }
  else
    {
      hrt->message = gm_hton_up ((gm_up_t) ptr);
      hrt->tag = gm_hton_u8 ((gm_u8_t) tag);
      hrt->priority = gm_hton_u8 ((gm_u8_t) priority);
      hrt->size = gm_hton_u8 ((gm_u8_t) size);
      GM_STBAR ();
      hrt->ready = gm_hton_u8 (1);
    }

  /* advance the receive token queue. */

  GM_READBACK_TO_FLUSH_WRITES (p, hrt);

  if (++p->recv_token_queue_slot >= p->recv_token_queue_limit)
    p->recv_token_queue_slot = p->recv_token_queue_start;
}

GM_ENTRY_POINT
void
gm_provide_receive_buffer (gm_port_t * p, void *ptr, unsigned int size,
			   unsigned int priority)
{
  gm_provide_receive_buffer_with_tag (p, ptr, size, priority, 0);
}
