/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1999,2000 by Myricom, Inc.                              *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_debug.h"
#include "gm_internal.h"

#if !GM_KERNEL
#ifdef STDC_HEADERS
#include <stdio.h>
#endif
#endif /* !GM_KERNEL */

/* Much like ANSI perror(), only requires that the user pass in the
   error code, allowing a future thread-safe implementation. */

GM_ENTRY_POINT void
gm_perror (const char *message, gm_status_t error)
{
  const char *description;
  const char *tmpl;
  
  description = gm_strerror (error);
  
  if ((unsigned int) error >= (unsigned int) GM_NUM_STATUS_CODES)
    {
      tmpl = "%s: %s %u\n";
    }
  else
    {
      tmpl = "%s: %s\n";
    }
  
#if GM_KERNEL
  GM_INFO ((tmpl, message, description, (unsigned int) error));
#else
  fprintf (stderr, tmpl, message, description, (unsigned int) error);
  fflush (stderr);
#endif
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
