/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

GM_ENTRY_POINT
gm_status_t
gm_node_id_to_unique_id (gm_port_t *port, unsigned int n, char *uid)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  gm_assert (is->ethernet.addr_tab.volatile_ethernet_addr);

  if (n > is->max_node_id) 
    return GM_INVALID_PARAMETER;

  return
    gm_copyout (ps, is->ethernet.addr_tab.volatile_ethernet_addr[n].as_bytes,
		uid, 6);
#else
  gm_status_t status;
  union {
    unsigned int in;
    char out[6];
  } buf;

  buf.in = n;

  status = _gm_user_ioctl (port, GM_NODE_ID_TO_UNIQUE_ID, &buf, sizeof (buf));
  if (status != GM_SUCCESS)
    return status;
  uid[0] = buf.out[0];
  uid[1] = buf.out[1];
  uid[2] = buf.out[2];
  uid[3] = buf.out[3];
  uid[4] = buf.out[4];
  uid[5] = buf.out[5];
  return GM_SUCCESS;
#endif
}
