#include "gm_internal.h"

#ifdef STDC_HEADERS
#  include <stdlib.h>
#endif

/* Return a buffer of the specified alignment. */

void *
gm_memalign (unsigned long alignment, unsigned long len)
{
#if !GM_KERNEL && defined HAVE_MEMALIGN
  return memalign (alignment, len);
#else
  void *ret;
  
  if (!GM_POWER_OF_TWO (alignment))
    return 0;
  

  /* Try simple malloc, just in case it works. */

  ret = gm_malloc (len);
  if (ret)
    {
      if (((long)ret & (alignment-1)) == 0)
	return ret;
      gm_free (ret);
    }

  /* Try tricking a power-of-two memory allocator into returning an
     aligned buffer. */

  if (alignment <= len)
    return 0;
  ret = gm_malloc (alignment);
  if (((long)ret & (alignment-1)) == 0)
    return ret;
  gm_free (ret);

  GM_NOTE (("Could not HACK memalign functionality.\n"));
  return 0;
#endif
}
