/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_internal.h"

GM_ENTRY_POINT
gm_status_t
gm_max_node_id (gm_port_t *port, unsigned int *n)
{
#if GM_KERNEL
  gm_port_state_t *ps;

  GM_CALLED_WITH_ARGS (("%p,%p", port, n));
  ps  = port->kernel_port_state;
  GM_RETURN_STATUS (gm_copyout (ps, &ps->instance->max_node_id, n,
				sizeof (*n)));
#else
  gm_status_t status = GM_SUCCESS;

  if (!port->max_node_id)
    {
      status = _gm_user_ioctl (port, GM_GET_MAX_NODE_ID, &port->max_node_id,
			       sizeof (port->max_node_id));
      if (status != GM_SUCCESS)
	port->max_node_id = 0;
    }
  *n = port->max_node_id;
  return status;
#endif
}

