/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#if GM_MCP
#include "gm.h"
#else
#include "gm_internal.h"
#endif

GM_ENTRY_POINT const unsigned char
gm_log2_roundup_table[257] = {
  0,
  0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
};

GM_ENTRY_POINT unsigned long
gm_log2_roundup (unsigned long n)
{
  unsigned ret;

  if (n <= 0x100)
    ret = gm_log2_roundup_table[n] + 0;
  else
    {
      n = (n+0xff)>>8 & 0xffffff;
      if (n <= 0x100)
	ret = gm_log2_roundup_table[n] + 8;
      else
	{
	  n = (n+0xff)>>8;
	  if (n <= 0x100)
	    ret = gm_log2_roundup_table[n] + 16;
	  else
	    {
	      n = (n+0xff)>>8;
	      ret = gm_log2_roundup_table[n] + 24;
	    }
	}
    }
  return ret;
}

#if GM_TEST_LOG2
int
main ()
{
  int i;
  
  gm_always_assert (gm_log2_roundup (0) == 0);
  for (i=0; i<32; i++)
    gm_always_assert (gm_log2_roundup (1 << i) == i);
  for (i = 0x1000000; i; i--)
    {
      gm_always_assert (1 << gm_log2_roundup (i) >= i);
      gm_always_assert (1 << gm_log2_roundup (i) >> 1 < i);
    }
  printf ("Test passed.\n");
  return 0;
}
#endif
