#include "gm_internal.h"

#include "gm_lanai_dump.h"

static gm_dump_connection_t * ntoh_connection(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                              gm_lanai_globals_t *g,gm_connection_lp_t c)
{
  int temp;
  if (c == 0)
    return 0;
  temp = (gm_ntohl(c) - (long)((unsigned char*)g->connection-sram))/sizeof(g->connection[0]);
  gm_always_assert(temp>=0 && temp <= dest->max_node_id);
  return dest->connection+temp;
}

static gm_dump_subport_t * ntoh_subport(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                              gm_lanai_globals_t *g,gm_subport_lp_t sp)
{
  int temp;
  if (sp == 0)
    return 0;
  temp = (gm_ntohl(sp) - (long)((unsigned char*)g->_subport-sram))/sizeof(g->_subport[0]);
  gm_always_assert(temp>=0 && temp < GM_NUM_SUBPORTS);
  return dest->_subport+temp;
}

static gm_dump_send_record_t * ntoh_send_record(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_send_record_lp_t sr)
{
  int temp;
  if (sr == 0)
    return 0;
  temp = (gm_ntohl(sr) - (long)((unsigned char*)g->_send_record-sram))/sizeof(g->_send_record[0]);
  gm_always_assert(temp>=0 && temp < GM_NUM_SEND_RECORDS);
  return dest->_send_record+temp;
}

static gm_dump_port_protected_lanai_side_t * ntoh_port(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_port_protected_lanai_side_lp_t p)
{
  int temp;
  if (p == 0)
    return 0;
  temp = (gm_ntohl(p) - (long)((unsigned char*)g->port-sram))/sizeof(g->port[0]);
  gm_always_assert(temp>=0 && temp < GM_NUM_PORTS);
  return dest->port+temp;
}

static gm_dump_send_token_t * ntoh_send_token(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_send_token_lp_t t)
{
  int i,temp;
  if (t == 0)
    return 0;
  /* send_tokens are either ethernet tokens or mapper token ot port tokens */
  if (gm_ntohl(t) == ((unsigned char*)&g->ethernet.send.token-sram))
    return &dest->ethernet.send.token;
  if (gm_ntohl(t) == ((unsigned char*)&g->mapper_state.scout_reply.send_token-sram))
    return (gm_dump_send_token_t *) &dest->mapper_state.scout_reply.send_token; /* FIXME: plain wrong, bad type */
  if (gm_ntohl(t) == ((unsigned char*)&g->mapper_state.config_reply.send_token-sram))
    return (gm_dump_send_token_t *) &dest->mapper_state.config_reply.send_token; /* FIXME: plain wrong, bad type */
  for (i=0;i<GM_NUM_PORTS;i++) {
    temp = (gm_ntohl(t) - (long)((unsigned char*)g->port[i]._send_tokens-sram))/sizeof(gm_send_token_t);
    if (temp >= 0 && temp < GM_NUM_SEND_TOKENS)
      break;
  }
  gm_always_assert(i < GM_NUM_PORTS);
  return dest->port[i]._send_tokens+temp;
}

static gm_recv_token_t * ntoh_recv_token(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_recv_token_lp_t t)
{
  int i,temp;
  if (t == 0)
    return 0;
  for (i=0;i<GM_NUM_PORTS;i++) {
    temp = (gm_ntohl(t) - (long)((unsigned char*)g->port[i]._recv_tokens-sram))/sizeof(gm_recv_token_t);
    if (temp >= 0 && temp < GM_NUM_RECV_TOKENS)
      break;
  }
  gm_always_assert(i < GM_NUM_PORTS);
  return dest->port[i]._recv_tokens+temp;
}

static gm_host_send_token_t * ntoh_host_send_token(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_host_send_token_lp_t t)
{
  int p,temp,offset;
  if (t == 0)
    return 0;
  offset = gm_ntohl(t)-gm_htonl(g->_PORT);
  p = offset/GM_PAGE_LEN;
  gm_always_assert(p >= 0 && p < GM_NUM_PORTS);
  temp = ((offset % GM_PAGE_LEN)-GM_OFFSETOF(gm_port_unprotected_lanai_side_t,send_token_queue))
    /sizeof(gm_host_send_token_t);
  if (temp < 0 || temp >= GM_NUM_SEND_TOKENS) {
    GM_NOTE (("ntoh_host_send_token: cannot convert lp_t=0x%x\n",gm_ntohl(t)));
    return (void*)-1L;
  }
  return dest->_PORT[p].send_token_queue+temp;
}
static gm_host_recv_token_t * ntoh_host_recv_token(gm_dump_lanai_globals_t *dest, unsigned char *sram,
                                                gm_lanai_globals_t *g,gm_host_recv_token_lp_t t)
{
  int p,temp,offset;
  if (t == 0)
    return 0;
  offset = gm_ntohl(t)-gm_htonl(g->_PORT);
  p = offset/GM_PAGE_LEN;
  gm_always_assert(p >= 0 && p < GM_NUM_PORTS);
  temp = ((offset % GM_PAGE_LEN)-GM_OFFSETOF(gm_port_unprotected_lanai_side_t,recv_token_queue))
    /sizeof(gm_host_recv_token_t);
  if (temp >= 0 && temp <= GM_NUM_RECV_TOKENS)
    return dest->_PORT[p].recv_token_queue+temp;
  else {
    GM_NOTE (("ntoh_host_recv_token:cannot convert lp_t=0x%x\n",gm_ntohl(t)));
    return (gm_host_recv_token_t *) -1;
  }
}

static gm_sexno_t ntoh_sexno(gm_sexno_t val)
{
  gm_sexno_t ret;
  ret.parts.sesno = gm_ntohs(val.parts.sesno);
  ret.parts.seqno = gm_ntohs(val.parts.seqno);
  return ret;
}

#if GM_KERNEL
struct gm_dump_lanai_globals *gm_pseudo_global_clone(gm_instance_state_t *is)
#else
static struct gm_lanai_globals *glob_raw_copy;
struct gm_dump_lanai_globals *gm_pseudo_global_clone(gm_port_t * port)
#endif
{
  gm_lanai_globals_t *g = 0;
  gm_u32_t goff;
  unsigned char *lram;
  gm_dump_lanai_globals_t *dest = 0;
  gm_dump_port_unprotected_lanai_side_t *unprotected_port;
  int i,len;

#if GM_KERNEL
  g = (gm_lanai_globals_t *) is->lanai.globals;
  lram = (unsigned char *) is->lanai.sram;
#else
  len = sizeof(struct gm_lanai_globals) + (port->max_node_id + 1) * sizeof(struct gm_connection);
  g = glob_raw_copy = gm_malloc(len);
  if (!g)
    GM_PANIC (("out of memory"));
  if (_gm_get_globals(port,(gm_u8_t*)g,len) != GM_SUCCESS) {
    GM_PANIC (("gm_get_globals"));
  }
  if (_gm_user_ioctl (port, GM_GET_GLOBALS_OFFSET,
		      &goff, sizeof (goff))
      != GM_SUCCESS)
    {
      GM_NOTE (("Could not get globals offset.\n"));
      goto failure;
    }
  lram = (char*)g - goff;
#endif
  dest = gm_malloc(sizeof(*dest));
  if (!dest)
    goto failure;
  gm_bzero(dest,sizeof(*dest));

  dest->_PORT = gm_malloc(GM_PAGE_LEN*GM_NUM_PORTS);
  if (!dest->_PORT)
    goto failure;
  gm_bzero(dest->_PORT,GM_PAGE_LEN*GM_NUM_PORTS);
  gm_always_assert(sizeof(dest->_PORT[0]) == GM_PAGE_LEN);
  
  dest->max_node_id = gm_ntohs(g->max_node_id);
  dest->connection = gm_malloc((dest->max_node_id+1)*sizeof(*dest->connection));
  if (!dest->connection)
    goto failure;
  gm_bzero(dest->connection,(dest->max_node_id+1)*sizeof(*dest->connection));

  dest->magic = gm_htonl(g->magic);
#if GM_KERNEL
  unprotected_port = (gm_dump_port_unprotected_lanai_side_t *)(lram+gm_ntohl(g->_PORT));
  for (i=0;i<GM_NUM_PORTS;i++)
    dest->_PORT[i] = *unprotected_port++;
#else
  if (port->lanai)
    memcpy(&dest->_PORT[port->id],port->lanai,sizeof(gm_dump_port_unprotected_lanai_side_t));
  else
    memset(&dest->_PORT[port->id],0,sizeof(gm_dump_port_unprotected_lanai_side_t));
#endif
  dest->dma_descriptor.next_with_flags = gm_ntohl(g->dma_descriptor.next_with_flags);
  dest->dma_descriptor.csum[0] = gm_ntohs(g->dma_descriptor.csum[0]);
  dest->dma_descriptor.csum[1] = gm_ntohs(g->dma_descriptor.csum[1]);
  dest->dma_descriptor.len = gm_ntohl(g->dma_descriptor.len);
  dest->this_node_id = gm_ntohs(g->this_node_id);
/* dest->port_to_wake = gm_ntohs(g->port_to_wake); */
  /* ... */
  dest->first_port_with_sent_packets = ntoh_port(dest,lram,g,g->first_port_with_sent_packets);
  dest->free_subports = ntoh_subport(dest,lram,g,g->free_subports);

  for (i=0;i<GM_NUM_SUBPORTS;i++) {
    gm_dump_subport_t *new_p = dest->_subport+i;
    gm_subport_t *src_p = g->_subport+i;
    new_p->next = ntoh_subport(dest,lram,g,src_p->next);
    new_p->prev = ntoh_subport(dest,lram,g,src_p->prev);
    new_p->connection = ntoh_connection(dest,lram,g,src_p->connection);
    new_p->first_send_token = ntoh_send_token(dest,lram,g,src_p->first_send_token);
    new_p->last_send_token = ntoh_send_token(dest,lram,g,src_p->last_send_token);
    new_p->delay_until = gm_ntohl(src_p->delay_until);
    new_p->id = gm_ntohc(src_p->id);
    new_p->disabled = gm_ntohc(src_p->disabled);
  }
  
  dest->timeout_time = gm_ntohl(g->timeout_time);
  dest->sram_length = gm_ntohl(g->sram_length);
  dest->_state = gm_ntohl(g->state);
  dest->free_recv_chunk_cnt = gm_ntohl(g->free_recv_chunk_cnt);
  dest->current_rdma_port = ntoh_port(dest,lram,g,g->current_rdma_port);
  dest->registered_raw_recv_port = ntoh_port(dest,lram,g,g->registered_raw_recv_port);

  dest->free_send_chunk_cnt = gm_ntohl(g->free_send_chunk_cnt);
  dest->first_connection_to_ack = ntoh_connection(dest,lram,g,g->first_connection_to_ack);

  for (i=0;i<2;i++) {
    dest->send_chunk[i] = g->send_chunk[i];
  }
  for (i=0;i<2;i++) {
    dest->recv_chunk[i] = g->recv_chunk[i];
  }

  dest->first_active_connection = ntoh_connection(dest,lram,g,g->first_active_connection);
  dest->free_send_records = ntoh_send_record(dest,lram,g,g->free_send_records);
  for (i=0;i<GM_NUM_SEND_RECORDS;i++) {
    gm_dump_send_record_t *new_sr = dest->_send_record+i;
    gm_send_record_t *src_sr = g->_send_record+i;
    new_sr->next = ntoh_send_record(dest,lram,g,src_sr->next);
    new_sr->send_token = ntoh_send_token(dest,lram,g,src_sr->send_token);
    new_sr->before_ptr = (long)gm_ntohp(src_sr->before_ptr);
    new_sr->sexno = ntoh_sexno(src_sr->sexno);
    new_sr->before_len = gm_ntohl(src_sr->before_len);
    new_sr->orig_send_time = gm_ntohl(src_sr->orig_send_time);
    new_sr->resend_time = gm_ntohl(src_sr->resend_time);
  }

  dest->remaining_sdma_ctr = gm_ntohl(g->remaining_sdma_ctr);
  dest->remaining_rdma_ctr = gm_ntohl(g->remaining_rdma_ctr);
  dest->remaining_sdma_lar = gm_ntohl(g->remaining_sdma_lar);
  dest->remaining_rdma_lar = gm_ntohl(g->remaining_rdma_lar);
  dest->remaining_sdma_hp = (void*)gm_ntohp(g->remaining_sdma_hp);
  dest->remaining_rdma_hp = (void*)gm_ntohp(g->remaining_rdma_hp);
  /* ... */
  dest->pause_rqst = gm_ntohl(g->pause_rqst);
/* dest->pause_ack = gm_ntohl(g->pause_ack); */
  dest->port_to_close = gm_ntohl(g->port_to_close);
  if (GM_ENABLE_ERROR_COUNTERS)
    {
      dest->nack_cnt = gm_ntohl(g->nack_cnt);
      dest->drop_cnt = gm_ntohl(g->drop_cnt);
      dest->resend_cnt = gm_ntohl(g->resend_cnt);
      dest->bogus_header_cnt = gm_ntohl(g->bogus_header_cnt);
      dest->out_of_sequence_cnt = gm_ntohl(g->out_of_sequence_cnt);
      dest->too_small_cnt = gm_ntohl(g->too_small_cnt);
    }
  /* ... */
  for (i=0;i<GM_NUM_PORTS;i++) {
    int j;
    gm_dump_port_protected_lanai_side_t *new_p = dest->port+i;
    gm_port_protected_lanai_side_t *src_p = g->port+i;
    new_p->send_token_queue_slot = ntoh_host_send_token(dest,lram,g,src_p->send_token_queue_slot);
    new_p->recv_token_queue_slot = ntoh_host_recv_token(dest,lram,g,src_p->recv_token_queue_slot);
    new_p->alarm_set = gm_ntohc(src_p->alarm_set);
    new_p->privileged = gm_ntohc(src_p->privileged);
    new_p->wake_host = gm_ntohc(src_p->wake_host);
    new_p->open = gm_ntohc(src_p->open);
    /*new_p->free_send_tokens = ntoh_send_token(dest,lram,g,src_p->free_send_tokens);*/
    new_p->free_recv_tokens = ntoh_recv_token(dest,lram,g,src_p->free_recv_tokens);
    for (j=0;j<GM_NUM_SEND_TOKENS;j++) {
      gm_dump_send_token_t *new_t = new_p->_send_tokens+i;
      gm_send_token_t *src_t = src_p->_send_tokens+i;
      new_t->common.next = ntoh_send_token(dest,lram,g,src_t->common.next);
      new_t->common.type = gm_ntohc(src_t->common.type);
      new_t->common.sendable = gm_ntohl(src_t->common.sendable);
      new_t->common.subport = ntoh_subport(dest,lram,g,src_t->common.subport);
      new_t->ackable.target_subport_id = gm_ntohs(src_t->ackable.target_subport_id);
      new_t->ackable.orig_ptr = (long)gm_ntohp(src_t->ackable.orig_ptr);
      new_t->ackable.send_ptr = (long)gm_ntohp(src_t->ackable.send_ptr);
    }
    for (j=0;j<GM_NUM_RECV_TOKENS;j++) {
      gm_recv_token_t *new_t = new_p->_recv_tokens+i;
      gm_recv_token_t *src_t = src_p->_recv_tokens+i;
      new_t->key.parts.sender_node_id = gm_ntohs(src_t->key.parts.sender_node_id);
      new_t->key.parts.sender_subport_id = gm_ntohc(src_t->key.parts.sender_subport_id);
      new_t->key.parts.target_subport_id = gm_ntohc(src_t->key.parts.target_subport_id);
      new_t->size = gm_ntohc(src_t->size);
      new_t->orig_ptr = gm_ntohc(src_t->orig_ptr);
      new_t->recv_ptr = gm_ntohc(src_t->recv_ptr);
    }
    for (j=0;j<GM_NUM_PRIORITIES;j++) {
      int k;
      for (k=0;k<34;k++)
        new_p->free_recv_token[j][k] = ntoh_recv_token(dest,lram,g,src_p->free_recv_token[j][k]);
    }
    new_p->next_with_alarm = ntoh_port(dest,lram,g,src_p->next_with_alarm);
    new_p->recv_queue_slot_num = gm_ntohl(src_p->recv_queue_slot_num);
    for (j=0;j<GM_NUM_RECV_QUEUE_SLOTS + GM_NUM_RECV_QUEUE_SLOTS%2;j++) {
      new_p->recv_queue_slot_dma_addr[j] = (long)gm_ntohl(src_p->recv_queue_slot_dma_addr[j]);
      new_p->recv_queue_slot_host_addr[j] = (long)gm_ntohp(src_p->recv_queue_slot_host_addr[j]);
    }
    new_p->next_with_sent_packets = ntoh_port(dest,lram,g,src_p->next_with_sent_packets);
    new_p->active_subport_cnt = gm_ntohl(src_p->active_subport_cnt);
    /* ... */
    new_p->id = gm_ntohl(src_p->id);
    for (j=0;j<GM_NUM_PRIORITIES;j++) {
      new_p->unacceptable_recv_sizes[j] = src_p->unacceptable_recv_sizes[j];
    }
    new_p->PORT = dest->_PORT+i;
  }
  
  dest->finishing_rdma_for_port = ntoh_port(dest,lram,g,g->finishing_rdma_for_port);
  dest->first_port_with_alarm = ntoh_port(dest,lram,g,g->first_port_with_alarm);
  /* ... */
  memcpy(g->log,dest->log,sizeof(dest->log));
  dest->log_slot = (struct gm_log_entry  *)(lram + gm_ntohl(g->log_slot));

  dest->hit_cnt = gm_ntohl(g->hit_cnt);
  dest->miss_cnt = gm_ntohl(g->miss_cnt);
  dest->pause_cnt = gm_ntohl(g->pause_cnt);

  for (i=0;i<GM_MAX_NUM_NAME_TABLE_PIECES;i++)
    dest->name_table_piece[i] = gm_ntohl(g->name_table_piece[i]);
  /* dest->max_node_id already done for connection allocation */
  dest->end_magic = gm_htonl(g->end_magic);
  for (i=0;i<=dest->max_node_id;i++) {
    gm_dump_connection_t *new_conn = dest->connection + i;
    gm_connection_t *src_conn = g->connection + i;
    new_conn->next_active = ntoh_connection(dest,lram,g,src_conn->next_active);
    new_conn->prev_active = ntoh_connection(dest,lram,g,src_conn->prev_active);
    new_conn->next_to_ack = ntoh_connection(dest,lram,g,src_conn->next_to_ack);
    new_conn->probable_crc_error_cnt = gm_ntohc(src_conn->probable_crc_error_cnt);
    new_conn->misrouted_packet_error_cnt = gm_ntohc(src_conn->misrouted_packet_error_cnt);
#if 0
    new_conn->flags = gm_ntohc(src_conn->flags);
#endif
    new_conn->route_len = gm_ntohc(src_conn->route_len);
    memcpy(new_conn->route, src_conn->route,sizeof(src_conn->route));
    /* TODO: new_conn->ack_packet */
    new_conn->send_sexno = ntoh_sexno(src_conn->send_sexno);
    new_conn->active_subport_bitmask = gm_ntohs(src_conn->active_subport_bitmask);
    new_conn->first_send_record = ntoh_send_record(dest,lram,g,src_conn->first_send_record);
    new_conn->last_send_record = ntoh_send_record(dest,lram,g,src_conn->last_send_record);
    new_conn->first_active_send_port = ntoh_subport(dest,lram,g,src_conn->first_active_send_port);
    new_conn->close_sexno = ntoh_sexno(src_conn->close_sexno);
    new_conn->open_time = gm_ntohl(src_conn->open_time);
    new_conn->close_time = gm_ntohl(src_conn->close_time);
  }
  return dest;
  
 failure:
  GM_NOTE (("GM:in pseudo_clone:out of memory\n"));
  gm_pseudo_free(dest);
  return 0;
}

void gm_pseudo_free(gm_dump_lanai_globals_t *g)
{
  if (!g)
    return;
  if (g->_PORT)
    gm_free(g->_PORT);
  if (g->connection)
    gm_free(g->connection);
  gm_free(g);
  return;
}

