/*******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

/* initialize and finalize GM. */

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_enable_security.h"
#include "gm_internal.h"

unsigned long _gm_initialized;
 /**/ struct gm_mutex *_gm_global_mutex;

#if defined WIN32 && !GM_KERNEL && GM_BUILDING_GM_LIB
#include <winsock.h>
static WSADATA gm_wsadata;
#endif

#ifdef DELETE_VXWORKS
#if GM_OS_VXWORKS
#include <setjmp.h>
extern jmp_buf gm_vxworks_fake_exit_env;
#endif
#endif

gm_status_t gm_init ()
{
#if GM_PRINT_VERSION
  static int printed;
#endif

  /* check for redundant inits. */

  if (_gm_initialized)
    {
      GM_PRINT(GM_PRINT_LEVEL >= 1,
               ("gm_init() bypassed; already initialized\n"));
      goto done;
    }
  else
      GM_PRINT(GM_PRINT_LEVEL >= 1, ("gm_init() entered for first time\n"));
#if GM_PRINT_VERSION
  if (!printed)
    {
      GM_INFO (("\n"));
      _GM_INFO (("Using GM version \"%s\" build \"%s.\"\n"
		 _gm_version, _gm_build_id));
      _GM_INFO (("Copyright (C) 1999, 2000, Myricom, Inc.\n"));
      printed = 1;
    }
#endif

#if GM_KERNEL
/* Warnings to be printed only in kernel mode */
#if !GM_ENABLE_SECURITY
  {
    static int security_warning_printed;

    if (!security_warning_printed)
      {
	GM_WARN (("Some security features are disabled in this GM build\n"
		  "to allow non-privileged users to map the network.\n"));
	security_warning_printed = 1;
      }
  }
#endif

#if GM_ENABLE_GALVANTECH_WORKAROUND
  {
    static int galvantech_warning_printed;

    if (!galvantech_warning_printed)
      {
	GM_WARN (("Galvantech SRAM bug checksum testing enabled"
		  " - expect reduced performance.\n"));
	galvantech_warning_printed = 1;
      }
  }
#endif

#if GM_NUM_PORTS != 8
  {
    static int num_ports_warning_printed;

    if (!num_ports_warning_printed)
      {
	GM_WARN (("Driver supports %d, not the standard 8, GM ports\n",
		  GM_NUM_PORTS));
	num_ports_warning_printed = 1;
      }
  }
#endif
#endif /* GM_KERNEL */

  _gm_global_mutex = gm_create_mutex ();
  if (!_gm_global_mutex)
    {
      GM_NOTE (("Could not create gm_global_mutex.\n"));
      goto abort_with_nothing;
    }

#if defined WIN32 && !GM_KERNEL && GM_BUILDING_GM_LIB
  /* Under Windows, intialize winsock. */

  if (WSAStartup (MAKEWORD (2, 0), &gm_wsadata) != 0)
    {
      GM_NOTE (("Could not initialize winsock.\n"));
      goto abort_with_global_mutex;
    }
#endif

#if GM_KERNEL
  if (__gm_init_port_state () != GM_SUCCESS)
    {
      goto abort_with_global_mutex;
    }
  /* gm_assert (GM_PAGE_LEN != 0); */
#else
  /* initialize GM_PAGE_LEN */

  if (_gm_get_page_len (&GM_PAGE_LEN) != GM_SUCCESS)
    {
      GM_NOTE (("Could not determine page length.\n"));
      goto abort_with_global_mutex;
    }
#endif

  /* initialize random number generator */

  gm_srand (42);

  /* report successful initialization */

done:
  gm_mutex_enter (_gm_global_mutex);
  _gm_initialized++;
  gm_mutex_exit (_gm_global_mutex);

#ifdef DELETE_VXWORKS
#if GM_OS_VXWORKS
  /* This is a hook to allow clean gm_exit()s in VxWorks */

  {
    int error;

    error = setjmp (gm_vxworks_fake_exit_env);
    if (error)
      {
	gm_close_all_ports ();
	return error;
      }
  }
#endif
#endif

  gm_always_assert (sizeof (gm_u8_t) == 1);
  gm_always_assert (sizeof (gm_u16_t) == 2);
  gm_always_assert (sizeof (gm_u32_t) == 4);
  gm_always_assert (sizeof (gm_u64_t) == 8);

  return GM_SUCCESS;

abort_with_global_mutex:
#if GM_KERNEL
  __gm_finalize_port_state ();
#else
  gm_destroy_mutex (_gm_global_mutex);
#endif
abort_with_nothing:
  return GM_FAILURE;
}

void
gm_finalize ()
{
  unsigned long initialized;

  GM_CALLED ();

#if GM_KERNEL
  __gm_finalize_port_state ();
#endif

  gm_mutex_enter (_gm_global_mutex);
  gm_assert (_gm_initialized);
  initialized = --_gm_initialized;
  gm_mutex_exit (_gm_global_mutex);

  /* escape if not yet time to finalize */

  if (initialized)
    GM_RETURN_NOTHING ();

  /* finalize */

  gm_destroy_mutex (_gm_global_mutex);
  GM_RETURN_NOTHING ();
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
