/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_debug.h"
#include "gm_internal.h"

#define GM_DEBUG_HANDLE_SENT_TOKENS 0
#define GM_DEBUG_OUTSTANDING_SENDS 0

/* Handle a GM_SENT_TOKENS_EVENT. */

GM_ENTRY_POINT void
gm_handle_sent_tokens (gm_port_t * p, gm_recv_event_t * e)
{
#if 1
  struct _gm_sent_token_report *report;
  unsigned int token;

  report = &e->tokens_sent.report[GM_NUM_ELEM (e->tokens_sent.report) - 1];
  for (token = gm_ntoh_u8 (report->token);
       (token = gm_ntoh_u8 (report->token)) != 0; report--)
    {
      struct gm_send_queue_slot_token *first, *last, *utoken;
      gm_status_t status;
      void *context;
      gm_send_completion_callback_t handler;

      GM_PRINT (GM_DEBUG_HANDLE_SENT_TOKENS,
		("Handling sent token 0x%x.\n", token - 1));

      /* read all */

      utoken = &p->send_queue_slot_token[token - 1];
      if (GM_DEBUG)
	{
	  /*gm_assert (utoken->pad); */
	  /*utoken->pad = 0; */
	}
      gm_always_assert (GM_NUM_STATUS_CODES <= 256);
      status = (gm_status_t) gm_ntoh_u8 (report->status);
      ;
      handler = utoken->sent_handler;
      utoken->sent_handler = 0;
      context = utoken->sent_handler_context;

      /* recycle slot */

      first = p->first_free_send_queue_slot_token;
      last = p->last_free_send_queue_slot_token;
      p->last_free_send_queue_slot_token = utoken;
      if (first)
	last->next = utoken;
      else
	p->first_free_send_queue_slot_token = utoken;

      /* perform callback.  We do this last in case the handler needs to
         reuse the send queue slot. */

      if (handler)
	(*handler) (p, context, status);
    }
#else
  struct _gm_sent_token_report *report;
  unsigned int token;
  struct gm_send_queue_slot_token *first, *last, *utoken;
  gm_sent_callback_t handler;
  void *context;
  gm_status_t status, next_status;

  report = &e->tokens_sent.report[GM_NUM_ELEM (e->tokens_sent.report) - 1];
  token = report->token;
  status = report->status;
  --report;
  gm_assert (token);
  first = p->first_free_send_queue_slot_token;
  last = p->last_free_send_queue_slot_token;

  /* NOTE: The following is codes as a manually unrolled loop for
     improved performance. */

  /* Handle first token */

  GM_PRINT (GM_DEBUG_HANDLE_SENT_TOKENS,
	    ("Handling sent token 0x%x.\n", token - 1));
  utoken = &p->send_queue_slot_token[token - 1];
  if (GM_DEBUG)
    {
      /*gm_assert (utoken->pad);
         utoken->pad = 0; */
    }
  token = report->token;
  next_status = report->status;
  --report;
  context = utoken->sent_handler_context;
  handler = utoken->sent_handler;
  gm_assert (context || handler);
  utoken->sent_handler = 0;
  if (GM_DEBUG)
    utoken->sent_handler_context = 0;
  if (!first)
    {
      GM_PRINT (GM_DEBUG_HANDLE_SENT_TOKENS, ("using hackery\n"));
      last = ((struct gm_send_queue_slot_token *)
	      ((char *) &p->first_free_send_queue_slot_token
	       - GM_OFFSETOF (struct gm_send_queue_slot_token, next)));
    }
  last->next = utoken;
  last = utoken;
  if (handler)
    (*handler) (p, context, status);
  status = next_status;
  GM_PRINT (GM_DEBUG_OUTSTANDING_SENDS,
	    ("%d outstanding sends\n", --p->send_count));

  /* Handle remaining tokens. */

  while (token)
    {
      GM_PRINT (GM_DEBUG_HANDLE_SENT_TOKENS,
		("Handling sent token 0x%x in while() loop.\n", token - 1));
      utoken = &p->send_queue_slot_token[token - 1];
      if (GM_DEBUG)
	{
	  /*gm_assert (utoken->pad);
	     utoken->pad = 0; */
	}
      token = report->token;
      next_status = report->status;
      --report;
      context = utoken->sent_handler_context;
      handler = utoken->sent_handler;
      gm_assert (context || handler);
      utoken->sent_handler = 0;
      if (GM_DEBUG)
	utoken->sent_handler_context = 0;
      last->next = utoken;
      last = utoken;
      if (handler)
	(*handler) (p, context, status);
      status = next_status;
      GM_PRINT (GM_DEBUG_OUTSTANDING_SENDS,
		("%d outstanding sends\n", --p->send_count));
    }

  /* finish up by properly terminating the list of free send queue slots */

  last->next = 0;
  p->last_free_send_queue_slot_token = last;
#endif
}



/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
