/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file is a cover for the usual Unix getpid() functionality. */

#include "gm_config.h"

#if !GM_KERNEL && HAVE_UNISTD_H
#include <unistd.h>
#endif

#if !GM_KERNEL && WIN32
#include <process.h>
#endif

#include "gm.h"

gm_pid_t gm_getpid (void)
{
#if GM_KERNEL
#if GM_OS_VXWORKS
  return (gm_pid_t) taskIdSelf ();  
#else /* !GM_OS_VXWORKS */
  /* return bogus value in ther kernel to indicate that no process has
     opened the port. */
  return (gm_pid_t) - 1;
#endif /* !GM_OS_VXWORKS */
#elif WIN32
  return _getpid ();
#else
  return getpid ();
#endif
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
