/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#include "gm_debug.h"
#endif

gm_status_t
gm_get_unique_board_id (gm_port_t * port, char unique[6])
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_u8_t uid[6];
  
  /* Return the settable address in the scout reply packet, not the
     static address in the EEPROM. */
  GM_PRINT (GM_PRINT_LEVEL >= 10,
	    ("gm_get_unique_board_id(port=%p, uniq=%p)\n",port,unique));
  GM_PRINT (GM_PRINT_LEVEL >= 10,
	    ("ps = %p  ps->instance = %p \n",ps,ps->instance));
  gm_read_lanai_global_byte_array
    (is, mapper_state.scout_reply.packet.address, uid);
  return gm_copyout (ps, uid, unique, 6);
#else
  return _gm_user_ioctl (port, GM_GET_UNIQUE_BOARD_ID, unique, 6);
#endif
}
