/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

GM_ENTRY_POINT
gm_status_t
gm_get_node_type (gm_port_t *port, int *node_type)
{
#if GM_KERNEL
  unsigned copy_node_type;

  gm_instance_state_t *is = port->kernel_port_state->instance;
  gm_assert (node_type);
  copy_node_type
    = gm_read_lanai_global_s16 (is, mapper_state.scout_reply.packet.node_type);

  return gm_copyout (port->kernel_port_state,
             &copy_node_type, node_type,
             sizeof (unsigned));

#else
  return _gm_user_ioctl (port, GM_GET_NODE_TYPE, node_type, sizeof (int));
#endif
}
