/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#include "gm_debug.h"
#endif

gm_status_t
gm_get_mapper_unique_id (struct gm_port *port, char *id)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_u8_t uid[6];

  gm_read_lanai_global_byte_array (is, mapper_state.unique_id, uid);
  GM_PRINT (GM_PRINT_LEVEL >= 4,
	    ("gm_get_mapper_unique_id returning %x:%x:%x:%x:%x:%x\n",
	     uid[0], uid[1], uid[2], uid[3], uid[4], uid[5]));
	    
  /* Copy the 6-byte ethernet address from scout reply message */

  return gm_copyout (ps, uid, id, 6);
#else
  /* indirectly call the kernel version of this function */
  return _gm_user_ioctl (port, GM_GET_MAPPER_UNIQUE_ID, id, 6);
#endif
}
