/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

GM_ENTRY_POINT
gm_status_t
gm_get_host_name (gm_port_t *port, char name[GM_MAX_HOST_NAME_LEN])
{
#if GM_KERNEL
  gm_instance_state_t *is = port->kernel_port_state->instance;
  char name_copy[GM_MAX_HOST_NAME_LEN];

  gm_read_lanai_global_byte_array
    (is, mapper_state.scout_reply.packet.hostname, name_copy);
  return gm_copyout (port->kernel_port_state, name_copy, name,
		     GM_MAX_HOST_NAME_LEN);
#else
  return _gm_user_ioctl (port, GM_GET_HOST_NAME, name,
			 GM_MAX_HOST_NAME_LEN);
#endif
}
