/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: feldy@myri.com */

#if GM_KERNEL
#error This file is not supported in the kernel.
#endif

#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_enable_fork_system.h"
#if HAVE_UNISTD_H
#include <unistd.h>
#else
#if GM_OS_SOLARIS
    pid_t
#else
    int
#endif
fork (void);        /* suppress missing prototype warning */
#endif


/* 'ENABLE' means allow users to have fork or system */
/*          means that we don't provide our own versions of fork/system */

#if (GM_ENABLE_FORK_SYSTEM==0)

int system (const char *cmd);	/* suppress missing prototype warning */

int
system (const char *cmd)
{
	GM_PARAMETER_MAY_BE_UNUSED (cmd);
	if (_gm_open_ports_test()) {
    		GM_WARN (("you can NOT call 'system()' in a GM program with ports open\n\n"));
    		return -1;
	}
	else {
#if 0 && GM_OS_LINUX
		return(__system(cmd));
#else
		GM_WARN (("how to actually call system now?\n"));
		return(-1);
#endif
	}

}

#if GM_OS_SOLARIS
    pid_t
#else
    int
#endif
fork()
  {
	if (_gm_open_ports_test()) {
		GM_WARN (("you can NOT call 'fork()' in a GM program with ports open.\n\n"));
		return -1;
	}
	else {
#if GM_OS_LINUX
		return(__fork());
#else
    	GM_WARN (("how to actually call 'fork' now\n"));
    	return -1;
#endif
	}
  }

#endif /* GM_ENABLE_FORK_SYSTEM */


int gm_fork()
{
	if (_gm_open_ports_test()) {
		GM_WARN (("you can NOT call 'fork()' in a GM program with ports open.\n\n"));
		return -1;
	}
	else {
#if GM_OS_LINUX
		return(__fork());
#else
		return(fork());
#endif
	}
}
