/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_on_exit.h"

#if GM_KERNEL && !GM_OS_VXWORKS
#else

#ifdef STDC_HEADERS
#include <stdlib.h>
#else
extern void exit (int status);
#endif


#if GM_OS_VXWORKS
extern GM_ENTRY_POINT void vxworks_gm_exit (gm_status_t status);
#endif

/****************
 * gm_on_exit() support
 *
 * This is here instead of in gm_on_exit.c to prevent drawing the
 * whole of gm_on_exit.o into applications that don't use gm_on_exit().
 ****************/

gm_on_exit_record_t *_gm_first_on_exit_record;

void
_gm_perform_on_exit_callbacks (gm_status_t status)
{
  gm_on_exit_record_t *next;
  
  while (_gm_first_on_exit_record)
    {
      (*_gm_first_on_exit_record->callback) (status,
					     _gm_first_on_exit_record->arg);
      next = _gm_first_on_exit_record->next;
      gm_free (_gm_first_on_exit_record);
      _gm_first_on_exit_record = next;
    }
}

GM_ENTRY_POINT void
gm_exit (gm_status_t status)
{
  /* clean up all GM global state. */

  GM_PRINT (GM_PRINT_LEVEL >= 2,("gm_exit entered in user mode\n"));

  _gm_perform_on_exit_callbacks (status);
  
#ifdef DELETE
  _gm_finalize_all ();
#endif /* DELETE */
  
  /* exit */

#if GM_OS_VXWORKS
  vxworks_gm_exit(status);
#else
  exit (status);
#endif
}
#endif
