/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_auto_config.h"
#include "gm.h"

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#elif TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

/* Return the current time as a double.  The time base is not specified,
   so this function can only be used for comparing times. */

double
gm_double_time ()
{
#ifdef WIN32
  SYSTEMTIME t;
  long secs;

  GetSystemTime (&t);
  secs = t.wSecond + 60 * (t.wMinute + 60 * (t.wHour + 24 * (t.wDay)));
  return (double) secs + (double) t.wMilliseconds / 1e3;
#elif GM_OS_VXWORKS
  TICK mytick;

  mytick = vxAbsTicks;
  return (double) mytick.lower;
#else
  struct timeval tv;
  if (gettimeofday (&tv, NULL) == -1)
    return GM_FAILURE;
  return (double) tv.tv_sec + (double) tv.tv_usec / 1e6;
#endif
  /* If we ever desperate enough, we can use gm_ticks() to get the time. */
}

/* return the precision of gm_double_time(), in seconds. */

double
gm_double_time_precision ()
{
#ifdef WIN32
  return 1e-3;
#elif GM_OS_VXWORKS
  return 1.0;
#else
  return 1e-6;
#endif
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
