/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: patrick@myri.com */

#include "gm_debug.h"
#include "gm_internal.h"

#define GM_DEBUG_DIRECTCOPY_GET 0

GM_ENTRY_POINT gm_status_t
gm_directcopy_get(struct gm_port *p, void *source_addr, void *target_addr, gm_size_t length, unsigned int source_instance_id, unsigned int source_port_id)
{
#if GM_OS_LINUX
  gm_directcopy_t args;
  
  GM_PRINT
    (GM_DEBUG_DIRECTCOPY_GET,
     ("directcopy: ioctl for directcopy from %p (%d,%d) to %p (length %lu)\n",
      source_addr, source_instance_id, source_port_id, target_addr, length));

  /* fill the structure for the args to pass to the kernel */
  args.source_addr = (gm_up_t)source_addr;
  args.target_addr = (gm_up_t)target_addr;
  args.length = length;
  args.source_instance_id = (gm_u16_t)source_instance_id;
  args.source_port_id = (gm_u16_t)source_port_id;
 
  /* pass the job to the kernel */ 
  return(_gm_user_ioctl(p, GM_DIRECTCOPY_GET, &args, sizeof(gm_directcopy_t))); 
#else
  GM_PRINT (1, ("directcopy: no support for directcopy in GM.\n"));
  return GM_FAILURE;
#endif
}
