/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file provides a standard place compilation warnings at the end
   of every compilation process where the builder is sure to notice
   them.  It is not really part of libgm.a. */

#include "gm_cpp.h"

/****************************************************************
 * Emit warnings for questionable feature settings.
 ****************************************************************/

#include "gm_debug.h"
#if GM_DEBUG
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_DEBUG is turned on, activating debug code.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_DEBUG is turned on, activating debug code.
#endif
#endif /* GM_DEBUG */



#include "gm_debug_lanai_dma.h"
#if GM_DEBUG_LANAI_DMA
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_DEBUG_LANAI_DMA enabled, generating slow code.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_DEBUG_LANAI_DMA is enabled, generating slow code.
#endif
#endif /* GM_DEBUG_SEND_TOKENS */

#include "gm_debug_recv_tokens.h"
#if GM_DEBUG_RECV_TOKENS
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_DEBUG_RECV_TOKENS enabled, generating slow code.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_DEBUG_RECV_TOKENS is enabled, generating slow code.
#endif
#endif /* GM_DEBUG_RECV_TOKENS */
	  
#include "gm_debug_send_tokens.h"
#if GM_DEBUG_SEND_TOKENS
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_DEBUG_SEND_TOKENS is enabled, generating slow code.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_DEBUG_SEND_TOKENS is enabled, generating slow code.
#endif
#endif /* GM_DEBUG_SEND_TOKENS */

#include "gm.h"
#include "gm_enable_crc32.h"
#if GM_ENABLE_CRC32
#if GM_CPP_WARNINGS_BEHAVE
#warning CRC32 is enabled for L7 and up. Will not be able to talk to L4-based cards.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error CRC32 is enabled for L7 and up. Will not be able to talk to L4-based cards.
#endif
#endif

#include "gm_enable_debug_counters.h"
#if GM_ENABLE_DEBUG_COUNTERS
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_DEBUG_COUNTERS is enabled, generating slow firmware.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_DEBUG_COUNTERS is enabled, generating slow firmware.
#endif
#endif /* GM_ENABLE_DEBUG_COUNTERS */

#include "gm_enable_directed_send.h"
#if !GM_ENABLE_DIRECTED_SEND
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_DIRECTED_SEND is disabled, disabling directed sends.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_DIRECTED_SEND is disabled, disabling directed sends.
#endif
#endif /* GM_ENABLE_DIRECTED_SEND */

#include "gm_enable_ethernet.h"
#if !GM_ENABLE_ETHERNET
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_ETHERNET is disabled, disabling ethernet.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_ETHERNET is disabled, disabling ethernet.
#endif
#endif /* GM_ENABLE_ETHERNET */

#include "gm_enable_galvantech_workaround.h"
#if GM_ENABLE_GALVANTECH_WORKAROUND
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_GALVANTECH_WORKAROUND is on, every packet will be checksummed
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_GALVANTECH_WORKAROUND is on, every packet will be checksummed
#endif
#endif /* GM_ENABLE_ETHERNET */

#include "gm_enable_jumbo_mtu.h"
#if GM_ENABLE_JUMBO_MTU
#if GM_CPP_WARNINGS_BEHAVE
#warning Jumbo MTU (9000bytes) is enabled for IP-over-GM
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error Jumbo MTU (9000bytes) is enabled for IP-over-GM
#endif
#endif /* GM_ENABLE_JUMBO_MTU */

#include "gm_enable_lmru_cache.h"
#if !GM_ENABLE_LMRU_CACHE
#if GM_CPP_WARNINGS_BEHAVE
#warning Glenn is experimenting with with a NON-LMRU cache.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error Glenn is experimenting with with a NON-LMRU cache.
#endif
#endif /* GM_ENABLE_LMRU_CACHE */

#include "gm_enable_packet_counters.h"
#if 0 && GM_ENABLE_PACKET_COUNTERS
#if GM_CPP_WARNINGS_BEHAVE
#warning Packet counters are enabled, slowing down the firmware slightly.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error Packet counters are enabled, slowing down the firmware slightly.
#endif
#endif /* GM_ENABLE_PACKET_COUNTERS */

#include "gm_enable_prototype_nic_support.h"
#if GM_ENABLE_PROTOTYPE_NIC_SUPPORT
#if GM_CPP_WARNINGS_BEHAVE
#warning Support for prototype NICs is enabled.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error Support for prototype NICs is enabled.
#endif
#endif /* GM_ENABLE_PROTOTYPE_NIC_SUPPORT */

#include "gm_enable_security.h"
#if !GM_ENABLE_SECURITY
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_SECURITY is disabled, disabling some security features.
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_SECURITY is disabled, disabling some security features.
#endif
#endif /* !GM_ENABLE_SECURITY */

#include "gm_enable_shortcut.h"
#if !GM_ENABLE_SHORTCUT
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_ENABLE_SHORTCUT is disabled, generating slower firmware
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_ENABLE_SHORTCUT is disabled, generating slower firmware
#endif
#endif /* !GM_ENABLE_SHORTCUT */

#include "gm_types.h"
#if GM_LOG_DISPATCHES
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_LOG_DISPATCHES is defined: logging MCP dispatches
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_LOG_DISPATCHES is defined: logging MCP dispatches
#endif
#endif /* GM_LOG_DISPATCHES */

#if (GM_NUM_PORTS != 8)
#if GM_CPP_WARNINGS_BEHAVE
#warning GM_NUM_PORTS is other than 8
#elif GM_CPP_ERRORS_BEHAVE_LIKE_WARNINGS
#error GM_NUM_PORTS is other than 8
#endif
#endif /* (GM_NUM_PORTS != 8) */

#if GM_NO_PARTWORD_PIO_WRITE && !GM_STRUCT_WRITE_COMBINING
#error If partword writes are not supported ( GM_NO_PARTWORD_PIO_WRITE == 1 )
#error then struct write combining must be enabled.
#endif

/* A stub function is included because some compilers don't like to
   compile C files that don't include at least one function. */

void gm_compile_warnings (void);	/* suppress missing prototype warnings */

void
gm_compile_warnings (void)
{
  return;
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/

