/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_malloc_debug.h"

#if !GM_KERNEL
#include <stdlib.h>
#endif

GM_ENTRY_POINT
void *
gm_calloc (gm_size_t len, gm_size_t cnt)
{
  void *ret;

  len *= cnt;

  ret = _gm_malloc (GM_STATIC_CAST (unsigned long, GM_MDEBUG_INTERNAL_LEN (len)));
  if (!ret)
    return ret;
  ret = GM_MDEBUG_CLIENT_PTR (ret);
  GM_MDEBUG_RECORD_CLIENT_PTR (ret, gm_free);

  gm_bzero (ret, len);
  return ret;
}
