/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_internal.h"

GM_ENTRY_POINT void
gm_abort ()
{
#if GM_KERNEL
  gm_arch_abort ();
#else
  GM_PRINT (GM_PRINT_LEVEL >= 2, ("gm_abort() entered in user mode\n"));
#  if defined WIN32
  /* Keep Windows from popping up a useless and annoying dialog box if the
     program fails. */
  GM_WARN (("Program aborted.\n"));
#endif
  /* Call gm_exit() to ensure correct cleanup on VxWorks. */
  gm_exit (GM_FAILURE);
#endif
}
