/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#include "gm_debug.h"
#endif

GM_ENTRY_POINT
gm_status_t
_gm_set_unique_id (gm_port_t *port, unsigned int node_id, char unique[6])
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_unique_id_64_t *to;

  if (ps->id != GM_MAPPER_PORT_ID)
    return GM_PERMISSION_DENIED;
  if (node_id > is->max_node_id)
    return GM_INVALID_PARAMETER;

  to = &is->ethernet.addr_tab.volatile_ethernet_addr[node_id];
  to->as_unswapped_u64 = 0;
  gm_bcopy (unique, to->as_bytes, 6);

  if (node_id == gm_read_lanai_global_u16 (is, this_node_id))
    {
      gm_write_lanai_global_byte_array
	(is, unique, mapper_state.scout_reply.packet.address);
      gm_write_lanai_global_byte_array
	(is, unique, mapper_state.config_reply.packet.address);
    }
  GM_PRINT (1, ("node %d has ethernet addr %02X:%02X:%02X:%02X:%02X:%02X.\n",
		node_id,
		unique[0] & 0xff, unique[1] & 0xff,
		unique[2] & 0xff, unique[3] & 0xff,
		unique[4] & 0xff, unique[5] & 0xff));
  return GM_SUCCESS;
#else
  struct
  {
    unsigned int node_id;
    char unique[6];
  } in;

  in.node_id = node_id;
  in.unique[0]  = unique[0];
  in.unique[1]  = unique[1];
  in.unique[2]  = unique[2];
  in.unique[3]  = unique[3];
  in.unique[4]  = unique[4];
  in.unique[5]  = unique[5];
  return _gm_user_ioctl (port, GM_SET_UNIQUE_ID, &in, sizeof (in));
#endif
}
