/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_debug.h"
#include "gm_internal.h"

/* Tell the driver the port number to be associated with this port. */

#define GM_DEBUG_SET_PORT_NUM 0

gm_status_t _gm_set_port_num (gm_port_t * port, unsigned long _id)
{
#if GM_KERNEL
  /* _gm_set_port_num not supported in kernel.  Must be intercepted in
     gm_arch.c */
  return GM_FAILURE;
#else /* in userland */
  gm_u32_t id;
  gm_status_t rv;

  id = _id;
  if (id >= GM_NUM_PORTS)
    return GM_FAILURE;
  GM_PRINT (GM_DEBUG_SET_PORT_NUM,
	    ("_gm_set_port_num: setting port number to %d.\n", id));
  rv = _gm_user_ioctl (port, GM_SET_PORT_NUM, &id, sizeof (id));
  GM_PRINT (GM_DEBUG_SET_PORT_NUM,
	    ("_gm_set_port_num: set port number (or failed to).\n"));
  return rv;

#endif /* in userland */
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
