/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_internal.h"

#define GM_DEBUG_SET_OPENER_PID 0

GM_ENTRY_POINT
gm_status_t
_gm_set_opener_pid(gm_port_t * p, gm_pid_t pid)
{
#if GM_KERNEL
	gm_instance_state_t *is;
	gm_port_state_t *ps;

	if (!p)
		return GM_FAILURE;

	ps = p->kernel_port_state;

	if (!ps) 
	  return GM_FAILURE;

	is = ps->instance;

	if (!is)
		return GM_FAILURE;

	GM_PRINT (GM_DEBUG_SET_OPENER_PID,
			  ("_gm_set_opener_pid kernel (port=%p, pid=%d)\n", p, pid));

	ps->opener_pid = pid;
	is->opener_pids[ps->id] = pid;

	return GM_SUCCESS;
#else
	GM_PRINT (GM_DEBUG_SET_OPENER_PID,
			  ("_gm_set_opener_pid (port=%p, pid=%d)\n", p, pid));
	return _gm_user_ioctl(p, GM_SET_OPENER_PID, &pid, sizeof(pid));
#endif
}


/*
  This file uses feldy indentation:

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
