/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

gm_status_t
_gm_set_node_type (gm_port_t * port, int node_type)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  
  GM_CALLED ();

  if (!ps->opened)
  {
    GM_NOTE (("User tried API function _gm_set_node_type()"));
    _GM_NOTE (("    on port before setting port number.\n"));
    return GM_PERMISSION_DENIED;
  }
  
  gm_assert (is);
  gm_assert (is->lanai.globals);

  gm_write_lanai_global_s16 (is, mapper_state.scout_reply.packet.node_type,
			     (gm_s16_t) node_type);
  
  GM_RETURN_STATUS (GM_SUCCESS);
#else
  return _gm_user_ioctl (port, GM_SET_NODE_TYPE, &node_type, sizeof (int));
#endif
}

