/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_enable_security.h"
#include "gm_pio.h"
#include "gm_debug.h"
#endif

gm_status_t
_gm_set_mapper_level (gm_port_t * port, int level)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  if (!ps->opened)
    {
      GM_NOTE (("User tried API function _gm_set_mapper_level()\n"
		"    on port before setting port number.\n"));
      return GM_PERMISSION_DENIED;
    }
  
  if (ps->id != GM_MAPPER_PORT_ID)
    return GM_PERMISSION_DENIED;
  if (GM_ENABLE_SECURITY && !ps->privileged)
    return GM_PERMISSION_DENIED;

  if (!is->lanai.running)
    return GM_UNATTACHED;

  GM_PRINT (GM_PRINT_LEVEL >= 1, ("Setting mapper level to %d.\n", level));

  gm_write_lanai_global_s32 (is, mapper_state.scout_reply.packet.level, level);
  return GM_SUCCESS;
#else
  gm_assert (port);
  return _gm_user_ioctl (port, GM_SET_MAPPER_LEVEL, &level, sizeof (level));
#endif
}
