/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

gm_status_t
_gm_set_host_name (gm_port_t * port, unsigned int node_id, char *name)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
   
  GM_CALLED ();
  if (!ps->opened)
    {
      GM_NOTE (("User tried API function _gm_set_host_name()\n"
		"    on port before setting port number.\n"));
      return GM_PERMISSION_DENIED;
    }
  
  gm_assert (is);
  GM_PRINT (GM_PRINT_LEVEL >= 10,
	    ("Verifying that node_id (%d) <= is->max_node_id (%d).\n",
	     node_id, is->max_node_id));
  if (node_id > is->max_node_id)
    {
      GM_NOTE (("tried to set host name for node id (%d)"
		" larger than is->max_node_id (%d)\n",
		node_id, is->max_node_id));
      GM_RETURN_STATUS (GM_PERMISSION_DENIED);
    }
  gm_assert (is->name_table.entry);
  if (node_id)
   {
     GM_PRINT (GM_PRINT_LEVEL >= 10,
	    ("strncpy (%p, %p, %d)\n", is->name_table.entry[node_id],
	     name, GM_MAX_HOST_NAME_LEN));
     GM_PRINT (GM_PRINT_LEVEL >= 10, ("name is \"%s\"\n", name));
     gm_strncpy (is->name_table.entry[node_id], name, GM_MAX_HOST_NAME_LEN);
   }

  gm_assert (is->lanai.globals);
  if (node_id == gm_read_lanai_global_u16 (is, this_node_id))
    {
      /* We have changed the name of this node, so update the mapper
         reply packets */

      gm_strncpy_to_lanai_globals
	(is, mapper_state.scout_reply.packet.hostname, name);
    }
  GM_RETURN_STATUS (GM_SUCCESS);
#else
  struct 
  {
    unsigned int node_id;
    char host_name[GM_MAX_HOST_NAME_LEN];
  } in;
      
  in.node_id = node_id;
  gm_strncpy (in.host_name, name, GM_MAX_HOST_NAME_LEN);
  return _gm_user_ioctl (port, GM_SET_HOST_NAME, &in, sizeof (in));
#endif
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
