/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_send_queue.h"

/* If no such request is pending already, ask that the LANai
   atomically generate a GM_SLEEP recv event, and generate an
   interrupt the next time it a recv event is generated.  Block until
   any recv event.

   This function should be called only by gm_blocking_receive. */
void
_gm_request_sleep (gm_port_t *p)
{
				/* Request to go to sleep, unless a
                                   sleep request is already pending.  */
  if (!p->sleep_pending)
    {
      p->sleep_pending = 1;
      __gm_post_simple_send_event (p, GM_SLEEP_RQST_EVENT);
    }

				/* Wait for a receive.  This will
                                   either be a genuine receive, which
                                   should cause us to wake up, or a
                                   _GM_SLEEP_EVENT, which will cause
                                   to user to call gm_unknown() and go
                                   to sleep for real. */
  while (!gm_receive_pending (p));
}
