/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_internal.h"

char *
_gm_recv_event_name (enum gm_recv_event_type t)
{
#define CASE(type) case type : return #type

  switch (t)
    {
      CASE (GM_NO_RECV_EVENT);
      CASE (GM_SENDS_FAILED_EVENT);
      CASE (GM_ALARM_EVENT);
      CASE (GM_SENT_EVENT);
      CASE (_GM_SLEEP_EVENT);
      CASE (GM_RAW_RECV_EVENT);
      CASE (GM_BAD_SEND_DETECTED_EVENT);
      CASE (GM_SEND_TOKEN_VIOLATION_EVENT);
      CASE (GM_RECV_TOKEN_VIOLATION_EVENT);
      CASE (GM_BAD_RECV_TOKEN_EVENT);
      CASE (GM_ALARM_VIOLATION_EVENT);
      CASE (GM_RECV_EVENT);
      CASE (GM_HIGH_RECV_EVENT);
      CASE (GM_PEER_RECV_EVENT);
      CASE (GM_HIGH_PEER_RECV_EVENT);
      CASE (GM_FAST_RECV_EVENT);
      CASE (GM_FAST_HIGH_RECV_EVENT);
      CASE (GM_FAST_PEER_RECV_EVENT);
      CASE (GM_FAST_HIGH_PEER_RECV_EVENT);
      CASE (GM_REJECTED_SEND_EVENT);
      CASE (GM_ORPHANED_SEND_EVENT);
      CASE (_GM_DIRECTED_SEND_NOTIFICATION_EVENT);
      /* CASE (GM_FREE_SEND_TOKEN_EVENT); */
      /* CASE (GM_FREE_HIGH_SEND_TOKEN_EVENT); */
      CASE (GM_BAD_RESEND_DETECTED_EVENT);
      CASE (GM_DROPPED_SEND_EVENT);
      CASE (GM_BAD_SEND_VMA_EVENT);
      CASE (GM_BAD_RECV_VMA_EVENT);
      CASE (_GM_FLUSHED_ALARM_EVENT);
      CASE (GM_SENT_TOKENS_EVENT);
      CASE (GM_IGNORE_RECV_EVENT);
      CASE (GM_NEW_NO_RECV_EVENT);
      CASE (GM_NEW_SENDS_FAILED_EVENT);
      CASE (GM_NEW_ALARM_EVENT);
      CASE (GM_NEW_SENT_EVENT);
      CASE (_GM_NEW_SLEEP_EVENT);
      CASE (GM_NEW_RAW_RECV_EVENT);
      CASE (GM_NEW_BAD_SEND_DETECTED_EVENT);
      CASE (GM_NEW_SEND_TOKEN_VIOLATION_EVENT);
      CASE (GM_NEW_RECV_TOKEN_VIOLATION_EVENT);
      CASE (GM_NEW_BAD_RECV_TOKEN_EVENT);
      CASE (GM_NEW_ALARM_VIOLATION_EVENT);
      CASE (GM_NEW_RECV_EVENT);
      CASE (GM_NEW_HIGH_RECV_EVENT);
      CASE (GM_NEW_PEER_RECV_EVENT);
      CASE (GM_NEW_HIGH_PEER_RECV_EVENT);
      CASE (GM_NEW_FAST_RECV_EVENT);
      CASE (GM_NEW_FAST_HIGH_RECV_EVENT);
      CASE (GM_NEW_FAST_PEER_RECV_EVENT);
      CASE (GM_NEW_FAST_HIGH_PEER_RECV_EVENT);
      CASE (GM_NEW_REJECTED_SEND_EVENT);
      CASE (GM_NEW_ORPHANED_SEND_EVENT);
      CASE (_GM_NEW_DIRECTED_SEND_NOTIFICATION_EVENT);
      CASE (GM_NEW_FREE_SEND_TOKEN_EVENT);
      CASE (GM_NEW_FREE_HIGH_SEND_TOKEN_EVENT);
      CASE (GM_NEW_BAD_RESEND_DETECTED_EVENT);
      CASE (GM_NEW_DROPPED_SEND_EVENT);
      CASE (GM_NEW_BAD_SEND_VMA_EVENT);
      CASE (GM_NEW_BAD_RECV_VMA_EVENT);
      CASE (_GM_NEW_FLUSHED_ALARM_EVENT);
      CASE (GM_NEW_SENT_TOKENS_EVENT);
      CASE (GM_NEW_IGNORE_RECV_EVENT);
    case GM_NUM_RECV_EVENT_TYPES:
      ;				/* ";" Required by SGI Mips Pro CC */
    }
  return "(bogus recv event type)";
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
