/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_compiler.h"
#include "gm_internal.h"

				/* mmap(), munmap() */
#if !GM_KERNEL
#  ifdef HAVE_SYS_TYPES_H
#    include <sys/types.h>
#  endif
#  ifdef HAVE_SYS_MMAN_H
#    include <sys/mman.h>
#  endif
#  ifdef HAVE_ERRNO_H
#    include <errno.h>
#  endif
#endif

gm_status_t
_gm_munmap (gm_port_t *p, void *ptr, unsigned long len)
{
  (void) p;
  
#if GM_KERNEL
  GM_PARAMETER_MAY_BE_UNUSED (p);
  GM_PARAMETER_MAY_BE_UNUSED (ptr);
  GM_PARAMETER_MAY_BE_UNUSED (len);
  
  return GM_SUCCESS;
#else
#  ifdef _WIN32
  return GM_SUCCESS; /* BAD */
#  else
  return (munmap (ptr, len) == 0 ? GM_SUCCESS : GM_FAILURE);
#  endif
#endif
}
