/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_internal.h"
#include "_gm_modsend.h"
#include "gm_send_queue.h"

/* Generic resend/drop_send/drop_sends function */

void
_gm_modsend (struct gm_port *p,
	     unsigned int priority,
	     unsigned int target_node_id,
	     unsigned int target_port_id,
	     enum gm_send_event_type type,
	     gm_send_completion_callback_t callback, void *context)
{
  struct gm_resend_send_event volatile *se;
  struct gm_resend_send_event batch_write;

  se = GM_SEND_QUEUE_SLOT (p, callback, context, resend);

  if (GM_STRUCT_WRITE_COMBINING)
    {
      batch_write.target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
      batch_write.target_subport_id
	= gm_hton_u8 ((gm_u8_t) GM_SUBPORT (priority, target_port_id));
      batch_write.type = gm_hton_u8 ((gm_u8_t) type);
      GM_COPY_TO_IO_SPACE (*se, batch_write);
    }
  else
    {
      se->target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
      se->target_subport_id
	= gm_hton_u8 ((gm_u8_t) GM_SUBPORT (priority, target_port_id));
      GM_STBAR ();
      se->type = gm_hton_u8 ((gm_u8_t) type);
    }
  GM_FLUSH_SEND_EVENT (p, se);
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
