#include "gm_internal.h"
#include "gm_io.h"

char *
_gm_ioctl_cmd_name (unsigned int cmd)
{
#define CASE(type) case type : return #type

  switch (cmd)
    {
/*    In the same order as gm_io.h, rather than in collating sequence.   */
      CASE (GM_SET_FLAGS);
      CASE (GM_GET_RQST);
      CASE (GM_ACCESS_GRANTED);
      CASE (GM_SLEEP);
      CASE (GM_GET_MAPPING_SPECS);
      CASE (GM_GET_LANAI_GLOBALS_PTR);
      CASE (GM_GET_NODE_ID);
      CASE (GM_RECV_QUEUE_UPDATE);
      CASE (GM_MMAP);
      CASE (GM_MAP_CONTROL);
      CASE (GM_MAP_SPECIAL);
      CASE (GM_ENABLE_RAW_RECEIVES);
      CASE (GM_SET_ROUTE);
      CASE (GM_GET_UNIQUE_BOARD_ID);
      CASE (GM_SET_NODE_ID);
      CASE (GM_SET_ACCEPTABLE_SIZES_LOW);
      CASE (GM_SET_ACCEPTABLE_SIZES_HIGH);
      CASE (GM_GET_PAGE_LEN);
      CASE (GM_REGISTER_MEMORY);
      CASE (GM_DEREGISTER_MEMORY);
      CASE (GM_GET_EEPROM);
      CASE (GM_GET_MAX_NODE_ID);
      CASE (GM_SET_MAPPER_LEVEL);
      CASE (GM_NODE_ID_TO_UNIQUE_ID);
      CASE (GM_UNIQUE_ID_TO_NODE_ID);
      CASE (GM_SET_HOST_NAME);
      CASE (GM_GET_HOST_NAME);
      CASE (GM_HOST_NAME_TO_NODE_ID);
      CASE (GM_NODE_ID_TO_HOST_NAME);
      CASE (GM_SET_UNIQUE_ID);
      CASE (GM_GET_ROUTE);
      CASE (GM_SET_PORT_NUM);
      CASE (GM_SET_REGISTER_MEMORY_LENGTH);
      CASE (GM_CLEAR_ALL_ROUTES);
      CASE (GM_GET_KERNEL_BUILD_ID_LEN);
      CASE (GM_GET_KERNEL_BUILD_ID);
      CASE (GM_GET_GLOBALS);
      CASE (GM_GET_MAX_NODE_ID_INUSE);
      CASE (GM_FINISH_MMAP);
      CASE (GM_GET_GLOBALS_OFFSET);
      CASE (GM_GET_DEV);
      CASE (GM_GET_MAPPER_UNIQUE_ID);
      CASE (GM_LINUX_DEBUG_MODULE);
      CASE (GM_GET_KTRACE);
      CASE (GM_GET_OPENER_PIDS);
      CASE (GM_SET_OPENER_PID);
      CASE (GM_REGISTER_MEMORY_BY_STRUCT);
      CASE (GM_DEREGISTER_MEMORY_BY_STRUCT);
      CASE (GM_SET_NODE_TYPE);
      CASE (GM_GET_NODE_TYPE);
      CASE (GM_GET_FIRMWARE_STRING);
      CASE (GM_COP_WAKEUP);
      CASE (GM_COP_SEND);
      CASE (GM_COP_RECEIVE);
      CASE (GM_COP_END);
      CASE (GM_DIRECTCOPY_GET);
      CASE (GM_GET_GLOBALS_BY_REQUEST);
      CASE (GM_WRITE_LANAI_REGISTER);
      CASE (GM_GET_PAGE_HASH_CACHE_SIZE);
      CASE (GM_SET_ENABLE_NACK_DOWN);
    }
    return "** unknown **";
}
