/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#ifndef WIN32
#  if !GM_KERNEL
#    include <unistd.h>
#  endif
#endif

				/* getpagesize() */
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif

				/* open() */
#ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#  include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#  include <fcntl.h>
#endif

/* Return the page length.  In the kernel, it has been precomputed.
   In user space, either a cached value is returned or the driver is
   asked for the page length via an IOCTL. */

gm_status_t
_gm_get_page_len (unsigned long *result)
{
#if GM_KERNEL
  return gm_arch_get_page_len (result);
#elif HAVE_UNISTD_H
  *result = (unsigned int) getpagesize ();
  if (!*result)
    return GM_FAILURE;
  return GM_SUCCESS;
#elif defined WIN32
#  if 1
#    if GM_CPU_x86
  *result = 4096;
#    elif GM_CPU_ia64
  *result = 8192;
#    else
#      error Unknown page size
#    endif
  return GM_SUCCESS;
#  else
  HANDLE fd;
  DWORD trash;

  fd = CreateFile ("\\\\.\\GM0", (GENERIC_READ | GENERIC_WRITE),
		   0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_SYSTEM, NULL);
  if (fd == INVALID_HANDLE_VALUE)
    {
      GM_NOTE (("Could not open GM device to get page size.\n"));
      goto abort_with_nothing;
    }
  if (DeviceIoControl (fd, GM_GET_PAGE_LEN,
		       &GM_PAGE_LEN, sizeof (GM_PAGE_LEN),
		       &GM_PAGE_LEN, sizeof (GM_PAGE_LEN),
		       &trash, NULL)
      != 0)
    {
      GM_NOTE (("Could not get page size from GM driver.\n"));
      goto abort_with_open_file;
    }
  CloseHandle (fd);
  *result = GM_PAGE_LEN;
  return GM_SUCCESS;

abort_with_open_file:
  CloseHandle (fd);
abort_with_nothing:
  return GM_FAILURE;
#  endif
#else /* !GM_KERNEL && !defined HAVE_UNISTD_H  && !defined WIN32 */
  int fd;

  fd = open ("/dev/gm0", O_RDONLY);
  if (fd == -1)
    {
      GM_NOTE (("Could not open /dev/gm0 to get page length.\n"));
      goto abort_with_nothing;
    }
  if (ioctl (fd, GM_GET_PAGE_LEN, &GM_PAGE_LEN, sizeof (GM_PAGE_LEN)) == -1)
    {
      GM_NOTE (("Could not get page len.\n"));
      goto abort_with_open_device;
    }
  close (fd);
  gm_assert (GM_PAGE_LEN);
  gm_assert (GM_POWER_OF_TWO (GM_PAGE_LEN));
  *result = GM_PAGE_LEN;
  return GM_SUCCESS;

abort_with_open_device:
  close (fd);
abort_with_nothing:
  return GM_FAILURE;
#endif
}
