/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_debug.h"
#endif

gm_status_t
_gm_get_mapping_specs (gm_port_t * port, gm_mapping_specs_t *ms)
{

#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;

  if (!ps->opened)
    {
      GM_NOTE (("User tried API function "__GM_FUNCTION__"\n"));
      _GM_NOTE (("    on port before setting port number.\n"));
      return GM_PERMISSION_DENIED;
    }
  
  GM_PRINT (GM_PRINT_LEVEL >= 4,
	    ("Returning mappings:\n"));
  
  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     control_regs: offset=0x%x len=0x%x\n",
	      ps->mappings.control_regs.offset,
	      ps->mappings.control_regs.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     special_regs: offset=0x%x len=0x%x\n",
	      ps->mappings.special_regs.offset,
	      ps->mappings.special_regs.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     sram: offset=0x%x len=0x%x\n",
	      ps->mappings.sram.offset,
	      ps->mappings.sram.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     hash_piece_ptrs: offset=0x%x len=0x%x\n",
	      ps->mappings.hash_piece_ptrs.offset,
	      ps->mappings.hash_piece_ptrs.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     send_queue: offset=0x%x len=0x%x\n",
	      ps->mappings.send_queue.offset,
	      ps->mappings.send_queue.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     copy_block: offset=0x%x len=0x%x\n",
	      ps->mappings.copy_block.offset,
	      ps->mappings.copy_block.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("     recv_queue: offset=0x%x len=0x%x\n",
	      ps->mappings.recv_queue.offset,
	      ps->mappings.recv_queue.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("            RTC: offset=0x%x len=0x%x\n",
	      ps->mappings.RTC.offset,
	      ps->mappings.RTC.len));

  _GM_PRINT (GM_PRINT_LEVEL >= 4,
	     ("Copying 0x%x bytes of mappings to user 0x%x\n",
	      sizeof (*ms), ms));
  
  return gm_copyout (ps, &ps->mappings, ms, sizeof (*ms));

#else  /* !GM_KERNEL */
  gm_assert (port);
  return _gm_user_ioctl (port, GM_GET_MAPPING_SPECS, ms, sizeof (*ms));
#endif /* !GM_KERNEL */
}
