/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_compiler.h"
#include "gm_internal.h"

GM_ENTRY_POINT
char *
_gm_get_kernel_build_id (gm_port_t *port)
{
#if GM_KERNEL
  GM_PARAMETER_MAY_BE_UNUSED (port);
  return (char *) _gm_build_id;
#else
  gm_status_t status;
  int len;
  char *buffer;
  
  /* If we got the kernel build ID from the kernel before, return the
     cached value. */

  if (port->kernel_build_id)
    return port->kernel_build_id;

  /* determine the length of the kernel build ID string */

  status = _gm_user_ioctl (port, GM_GET_KERNEL_BUILD_ID_LEN,
			   &len, sizeof (len));
  if (status != GM_SUCCESS)
    {
      gm_perror("get_kernel_build_id_len failed",status);
      goto abort_with_nothing;
    }

  if (len > GM_MAX_KERNEL_BUILD_ID_LEN) 
     len = GM_MAX_KERNEL_BUILD_ID_LEN;

  /* allocate space for the build ID string */

  buffer = gm_malloc (GM_MAX_KERNEL_BUILD_ID_LEN+8); /* freed in gm_close() */
  if (!buffer) 
    {
      gm_perror("gm_malloc failed in get_kernel_build_id",status);
      goto abort_with_buffer;
    }

  /* Copy the build ID string from the kernel */

  status = _gm_user_ioctl (port, GM_GET_KERNEL_BUILD_ID, buffer, len);
  if (status != GM_SUCCESS)
    {
      gm_perror("get_kernel_build_id ioctl failed",status);
      goto abort_with_buffer;
    }

  /* commit */

  port->kernel_build_id = buffer;
  return buffer;
  
 abort_with_buffer:
  gm_free (buffer);
 abort_with_nothing:
  return 0;
#endif
}
