/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_enable_security.h"
#include "gm_debug.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

#define GM_DEBUG_GET_GLOBALS 1

gm_status_t
_gm_get_globals (gm_port_t * port, gm_u8_t *ptr, gm_size_t length)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  gm_size_t len;

  GM_PRINT (GM_DEBUG_GET_GLOBALS,
            ("_gm_get_globals(%p, %p, 0x%x) entered\n", port, ptr, length));

  if (GM_ENABLE_SECURITY && !ps->privileged)
    return GM_PERMISSION_DENIED;

  len = GM_STATIC_CAST (gm_u32_t,
		     sizeof(struct gm_lanai_globals) + 
		     ((ps->instance->max_node_id + 1) *
		     sizeof(struct gm_connection)));


  if (length > len) {
	length = len;
  }
  
  {
    void *globals, *globals_copy;
    gm_status_t ret;

    /* The GLOBALS scratch var and cast are required to prevent
       compiler warnings with gcc. */
    
    globals = (void *) is->lanai.globals;
    globals_copy = gm_malloc (length+8);
    if (!globals_copy)
      return GM_OUT_OF_MEMORY;

    __gm_ntok_bcopy (is, globals, globals_copy, length);
    GM_PRINT (GM_DEBUG_GET_GLOBALS,
              ("_gm_get_globals copying 0x%x bytes to %p\n", length, ptr));
    ret = gm_copyout (ps, globals, (void *) ptr, length);
    gm_free (globals_copy);
    return ret;
  }

#else
  GM_PRINT (GM_DEBUG_GET_GLOBALS,
            ("_gm_get_globals(%p, %p, 0x%x) entered\n", port, ptr, length));

  gm_assert (port);
#if GM_OS_OSF1
  {
     gm_globals_request_t request;
     int mylen = length;
     int i;
     int offset=0;
     gm_status_t status;

     while (mylen > 0) {
     	if (mylen < GM_GLOBALS_REQUEST_BUFF_SIZE) {
	   request.len = mylen;
	}
	else {
	   request.len = GM_GLOBALS_REQUEST_BUFF_SIZE;
	}
     	request.offset = offset;

	status = _gm_user_ioctl (port, GM_GET_GLOBALS_BY_REQUEST, 
				&request, sizeof(gm_globals_request_t));
	if (status != GM_SUCCESS) {
	  return status;
	}
        gm_bcopy((char *)&request, ptr+offset,GM_GLOBALS_REQUEST_BUFF_SIZE);
	mylen  -= GM_GLOBALS_REQUEST_BUFF_SIZE;
	offset += GM_GLOBALS_REQUEST_BUFF_SIZE;
     }
     return status;
  }
#else
  return _gm_user_ioctl (port, GM_GET_GLOBALS, ptr, length);
#endif
#endif
}


struct gm_lanai_globals *_gm_lanai_globals_saved;

GM_ENTRY_POINT void
_gm_preserve_lanai_globals(gm_port_t * p)
{
    /* read the lanai_globals into user space so it will be saved in the dump */
    int i;
    int opened=0;
    gm_port_t *port = p;
    gm_size_t length;

    if (!port) 
      {
         for (i=0; i<GM_NUM_PORTS; i++) 
           {
             /* should we check more than board 0 ?? */
             if (_gm_open_common (&port, 0, i, "gm_preserve_lanai_globals",
                               GM_API_VERSION_1_0) == GM_SUCCESS)
               {
                  opened = 1;
                  break;
               }
           }
      }

    if (port)
      {
         length = GM_STATIC_CAST (int,
			       sizeof(struct gm_lanai_globals)+
			       ((port->max_node_id+1)*
				sizeof(struct gm_connection)));
         _gm_lanai_globals_saved = (struct gm_lanai_globals *) gm_malloc (length);
         if (_gm_lanai_globals_saved) 
           {
             if (_gm_get_globals(port, (gm_u8_t *) _gm_lanai_globals_saved, length) != GM_SUCCESS)
               {
                 /* too bad */
               }
           }
         if (opened) 
           {
              gm_close(port);
           }
      }
}
