/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

#define GM_DEBUG_GET_FIRMWARE_STRING 0

#if GM_DEBUG_GET_FIRMWARE_STRING
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

/* return a copy of a string from the firmware.  This can be useful for
   debugging. */

GM_ENTRY_POINT
gm_status_t
_gm_get_firmware_string (gm_port_t *port, gm_lp_t lanai_ptr,
			 char str[GM_MAX_FIRMWARE_STRING_LEN], gm_u32_t *length)
{
  GM_CALLED_WITH_ARGS (("%p,0x%x,%p", port, lanai_ptr, str));
  
#if GM_KERNEL
  {
    gm_port_state_t *ps = port->kernel_port_state;
    gm_instance_state_t *is = ps->instance;
    char copy[GM_MAX_FIRMWARE_STRING_LEN+8];
    char *scan;

    /* Make sure user specified a legitimate LANai SRAM offset. */

    if (lanai_ptr
	> is->lanai.eeprom.lanai_sram_size - GM_MAX_FIRMWARE_STRING_LEN)
      {
	GM_RETURN_STATUS (GM_INVALID_PARAMETER);
      }

    /* Copy the indicated string, or garbage */

    __gm_ntok_strncpy (is, copy, &is->lanai.sram[lanai_ptr],
		       GM_MAX_FIRMWARE_STRING_LEN-1);
    copy[GM_MAX_FIRMWARE_STRING_LEN-1] = 0;

    /* terminate string at first non-printing character, and erase any
       following characters up to the null terminator. */
    
    for (scan=copy; *scan; scan++)
      {
	if (!gm_isprint (*scan))
	  break;
      }
    while (*scan)
      {
	*scan++ = 0;
      }

    *length = (gm_u32_t)gm_strlen(copy);
    GM_RETURN_STATUS (gm_copyout (ps, copy, str, GM_MAX_FIRMWARE_STRING_LEN));
  }
#else  /* !GM_KERNEL */
  {
    gm_status_t status;

    *length = 0;
    *(gm_lp_t *) str = lanai_ptr;
    status = _gm_user_ioctl (port, GM_GET_FIRMWARE_STRING, str,
				    GM_MAX_FIRMWARE_STRING_LEN);
    if (status == GM_SUCCESS) 
      *length = gm_strlen(str);

    GM_RETURN_STATUS (status);
  }
#endif /* !GM_KERNEL */
}
