/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

gm_status_t
_gm_get_eeprom (gm_port_t * port, gm_myrinet_eeprom_t *ee)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  return gm_copyout (ps, &is->lanai.eeprom, ee, sizeof (*ee));
#else
  gm_assert (port);
  return _gm_user_ioctl (port, GM_GET_EEPROM, ee, sizeof (*ee));
#endif
}

