/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_internal.h"

				/* mmap(), munmap() */
#if !GM_KERNEL
#  ifdef HAVE_SYS_TYPES_H
#    include <sys/types.h>
#  endif
#  ifdef HAVE_SYS_MMAN_H
#    include <sys/mman.h>
#  endif
#  ifdef HAVE_ERRNO_H
#    include <errno.h>
#  endif
#endif

/* author: glenn@myri.com */

/* This function is called at the end of each successful user gm_mmap()
   call to inform the OS of the user VMA to which the resource was
   mapped. */

gm_status_t
_gm_finish_mmap (gm_port_t * port, gm_offset_t off, gm_size_t len,
		 gm_up_t uvma)
{
#if GM_KERNEL
  gm_port_state_t *ps;
  gm_status_t ret;

  GM_CALLED_WITH_ARGS (("0x%p, 0x%lx, 0x%lx, 0x%p",
			port, off, len, GM_STATIC_CAST (void*, uvma)));
  
  ps = port->kernel_port_state;

  /* Confirm that a legitimate mapping is being finished */

  GM_PRINT (GM_PRINT_LEVEL >= 3,
	    ("control offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	     (unsigned long) ps->mappings.control_regs.offset,
	     (unsigned long) off, (unsigned long) (off + len),
	     (unsigned long) (ps->mappings.control_regs.offset +
			      ps->mappings.control_regs.len)));

  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("special offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.special_regs.offset,
	      (unsigned long) off, (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.special_regs.offset +
			       ps->mappings.special_regs.len)));

  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("sram offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.sram.offset, (unsigned long) off,
	      (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.sram.offset +
			       ps->mappings.sram.len)));

  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("recv offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.recv_queue.offset,
	      (unsigned long) off, (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.recv_queue.offset +
			       ps->mappings.recv_queue.len)));

  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("send offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.send_queue.offset,
	      (unsigned long) off, (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.send_queue.offset +
			       ps->mappings.send_queue.len)));

  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("rtc offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.RTC.offset, (unsigned long) off,
	      (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.RTC.offset +
			       ps->mappings.RTC.len)));


  _GM_PRINT (GM_PRINT_LEVEL >= 3,
	     ("copy offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
	      (unsigned long) ps->mappings.copy_block.offset,
	      (unsigned long) off, (unsigned long) (off + len),
	      (unsigned long) (ps->mappings.copy_block.offset +
			       ps->mappings.copy_block.len)));


#define LEGIT_MAPPING(type)						\
  ((unsigned long)ps->mappings.type.offset <= (unsigned long)off					\
   && (unsigned long)(off+len) <= (unsigned long)(ps->mappings.type.offset + ps->mappings.type.len))

  if (!LEGIT_MAPPING (control_regs)
      && !LEGIT_MAPPING (special_regs)
      && !LEGIT_MAPPING (sram)
      && !LEGIT_MAPPING (recv_queue)
      && !LEGIT_MAPPING (send_queue)
      && !LEGIT_MAPPING (RTC) && !LEGIT_MAPPING (copy_block))
    {
      GM_PRINT (GM_PRINT_LEVEL >= 3,
		("legit_mapping fails %d %d %d %d %d %d %d\n",
		 LEGIT_MAPPING (control_regs), LEGIT_MAPPING (special_regs),
		 LEGIT_MAPPING (sram), LEGIT_MAPPING (recv_queue),
		 LEGIT_MAPPING (send_queue), LEGIT_MAPPING (RTC),
		 LEGIT_MAPPING (copy_block)));

      _GM_PRINT (GM_PRINT_LEVEL >= 3,
		 ("offset 0x%lx off 0x%lx off+len 0x%lx max 0x%lx\n",
		  (unsigned long) ps->mappings.control_regs.offset,
		  (unsigned long) off, (unsigned long) (off + len),
		  (unsigned long) (ps->mappings.control_regs.offset +
				   ps->mappings.control_regs.len)));
      
      GM_NOTE (("_gm_finish_mmap() failed to match LEGIT_MAPPING\n"));

      ret = GM_INVALID_PARAMETER;
      goto abort_with_nothing;
    }

#undef LEGIT_MAPPING

  /* ensure that all the resources have been allocated for this mapping. */
  GM_PRINT (GM_PRINT_LEVEL >= 1, ("prepare %p %d %d \n", ps, off, len));
  ret = gm_prepare_to_mmap (ps, off, len, 0);
  if (ret != GM_SUCCESS)
    {
      GM_PRINT (GM_PRINT_LEVEL >= 3, ("prepare_to_mmap fails\n"));
      goto abort_with_nothing;
    }
  /* Call the kernel version of this function now that we have done
     the security checks. */

  GM_RETURN_STATUS (gm_finish_mmap (ps, off, len, uvma));

abort_with_nothing:
  return ret;

#else /* !GM_KERNEL */
  struct gm_off_len_uvma s;

  GM_CALLED_WITH_ARGS (("0x%p, 0x%lx, 0x%lx, 0x%lx", port, off, len,
		       (unsigned long) uvma));

  s.offset = off;
  s.len = len;
  s.uvma = uvma;

  GM_RETURN_STATUS (_gm_user_ioctl (port, GM_FINISH_MMAP, &s, sizeof (s)));
#endif /* !GM_KERNEL */
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
