/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_enable_security.h"
#include "gm_pio.h"
#include "gm_debug.h"
#endif

gm_status_t
_gm_enable_raw_receives (gm_port_t *port)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  unsigned port_id;
  gm_lp_t raw_recv_port;
  
  if (!ps->opened)
    {
      GM_NOTE (("User tried API function _gm_enable_raw_receives()\n"
		   "\ton port before setting port number.\n"));
      return GM_PERMISSION_DENIED;
    }
  
  port_id = ps->id;

  if (GM_ENABLE_SECURITY && !ps->privileged)
    return GM_PERMISSION_DENIED;

  /* HACK: Use an existing mutex rather than introduce another, since this
     function is rarely called. */

  gm_arch_mutex_enter (&ps->instance->page_hash.sync);

  raw_recv_port = gm_read_lanai_global_lp (is, registered_raw_recv_port);
  if (raw_recv_port != 0
      && (raw_recv_port
	  != (gm_lp_t) ((char *) is->lanai.globals
			+ GM_OFFSETOF (gm_lanai_globals_t, port[port_id])
			- (char *) is->lanai.sram)))
      {
	gm_arch_mutex_exit (&ps->instance->page_hash.sync);
	return GM_BUSY;
      }

  gm_write_lanai_global_lp (is, registered_raw_recv_port,
			    (gm_lp_t) ((char *) is->lanai.globals
				       + GM_OFFSETOF (gm_lanai_globals_t,
						      port[port_id])
				       - (char *) is->lanai.sram));
  
  gm_arch_mutex_exit (&ps->instance->page_hash.sync);

  return GM_SUCCESS;
#else
  return _gm_user_ioctl (port, GM_ENABLE_RAW_RECEIVES, 0, 0);
#endif
}
