/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998 by Myricom, Inc.                       *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_enable_security.h"
#include "gm_pio.h"
#include "gm_debug.h"
#endif

GM_ENTRY_POINT
gm_status_t
_gm_clear_all_routes (gm_port_t *p)
{
#if GM_KERNEL
  gm_port_state_t *ps = p->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  if (GM_ENABLE_SECURITY && !ps->privileged)
    return GM_PERMISSION_DENIED;

  if (!is->lanai.running) {
    GM_PRINT (GM_PRINT_LEVEL >= 4, ("_gm_clear_all_routes: lanai.running is false\n"));
    return GM_UNATTACHED;
  }
  
  GM_PRINT (GM_PRINT_LEVEL >= 5, ("Clearing all routes\n"));
	
  {
    unsigned int index;

    gm_pause_lanai (is);
	GM_PRINT (GM_PRINT_LEVEL >= 5,("_gm_clear_all_routes: clearing %d routes\n",is->max_node_id));
    for (index=0; index<is->max_node_id; index++) {
      /*  GM_CONNECTION_CLEAR_ROUTE (...); */
      gm_write_lanai_global_u8 (is, connection[index].has_route, 0);
      gm_write_lanai_global_u8 (is, connection[index].route_len, 0);
      /* clear the ID field too */
      is->ethernet.addr_tab.volatile_ethernet_addr[index].as_unswapped_u64 = 0;
      /* clear the hostname too */
      is->name_table.entry[index][0] = 0;
    }
    gm_unpause_lanai (is);
  }
  
  return GM_SUCCESS;

#else
  {
    unsigned int u;
    /* this is just a dummy variable to help out osf1 ioctl problems */
    return _gm_user_ioctl (p, GM_CLEAR_ALL_ROUTES, &u, sizeof(unsigned int));
  }
#endif
}
