#define MAX_PRODUCT_CODE	(56)
#define PRODUCT_CODE_OK(code)	((code>=1)&&(code<=MAX_PRODUCT_CODE))?(1):(0)

/* 
   256 = A
   512 = B
  1024 = C
*/

struct MYRINET_EEPROM product_prom[] =
{
	/* NULL */
{ 0,0,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},0,{0},{0},
  0,0,0,0,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 1 == M2F-SBus32 256K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},256*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_SBUS,1,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 2 == M2F-PCI32a 256K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},256*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,2,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 3 == M2F-PCI32c 1024K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,3,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 4 == M2M-PCI32a 256K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},256*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,4,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 5 == M2M-PMC32a 256K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},256*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,5,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 6 == M2M-PMC32b 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,6,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 7 == M2F-GSC32 512K (kitty) */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_GSC,7,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 8 == M2M-PCI32c 1024K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,8,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 9 == M2F-GSC32S 512K (skyhawk) */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_GSC,9,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 10 == M2F-SBus32c 1024K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_SBUS,10,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 11 == FPGA Node 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_FPGA,MYRINET_BUS_FPGA,11,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 12 == M2M-PMC32b 512K (Galvantech memory) */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,12,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 13 == M2F-PCI32b 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,13,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 14 == M2F-SBus32b 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_SBUS,14,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 15 == M2M-PCI32b 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,15,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 16 == M2F-PCI32b 512K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,16,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 17 == M2F-PCI32c 1024K */
{ 0x50e450e4,0x0401,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,17,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 18 == M2F-PCI32-L5 1024K */
{ 0x06698200,0x0500,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,18,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 19 == M2M-PMC32c 1024K */
{ 0x50e450e4,0x0402,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,19,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 20 == M2L-GSC32H (LANai5.0) 1024K */
{ 0x06698200,0x0500,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x1e,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,20,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 21 == M2F-SBus32c (LANai4.3) 1024K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_SBUS,21,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 22 == M2F-SBus32b (LANai4.3) 512K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_SBUS,22,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 23 == M2F-PCI32b (LANai4.3) 512K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,23,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 24 == M2F-PCI32c (LANai4.3) 1024K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,24,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 25 == M2M-PCI32b (LANai4.3) 512K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,25,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 26 == M2M-PCI32c (LANai4.3) 1024K */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,26,0xFFFFFFFF,{0},0xFFFF,{0},0},

/*
0x05070690 for 1.5x
0x05070680 for 1x

0x06070790 for 1.5x 1/19/98
0x06070890 for 1.5x 1/28/98 30MHz bus Only
*/

/* 0x05070680 1x */
/* 27 == M2F-PCI32-L6 (LANai6.1) 1024K */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,27,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 28 == M2L-HSC32H (LANai6.1) 2048K */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,28,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 29 == M2L-GSC32H (LANai6.1) 1024K */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,29,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 30 == M2L-PCI32H-L6 (LANai6.1) 2048K */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,30,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 31 == 16-port microcontroller switch */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,31,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 32 == 16-port microcontroller switch  commercial */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,32,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 33 == M2L-PCI32H-L6 (LANai6.1) EISA 2048K */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,33,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 34 == 16-port microcontroller switch  M2LM-SW16 SAN/LAN */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,34,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 35 == 16-port microcontroller switch  M2M SAN */
{ 0x06070890,0x0601,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,35,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 36 == M2F-PCI32b (LANai4.3) 512K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,36,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 37 == M2F-PCI32c (LANai4.3) 1024K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,37,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 38 == M2M-PCI32b (LANai4.3) 512K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,38,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 39 == M2M-PCI32c (LANai4.3) 1024K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,39,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 40 == M2M-PMC32b (LANai4.3) 512K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},512*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_NONE,MYRINET_BUS_PCI,40,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 41 == M2M-PMC32c (LANai4.3) 1024K speed-grade 4 */
{ 0x90479047,0x0403,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_1MEG_SRAM,MYRINET_BUS_PCI,41,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 42 == M2M-PCI64 (LANai5.2) 1024K DMA controller */
{ 0x09698281,0x0502,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,42,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 43 == M2M-PCI64 (LANai7.0) SAN 2Meg DMA controller */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,43,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 44 == M2L-PCI64 (LANai7.0) LAN 2Meg DMA controller */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,44,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 45 == M2M-PCI64 (LANai7.0) LAN 4Meg DMA controller */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,45,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 46 == Fiber interface */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_FIBER,MYRINET_BUS_FIBER,46,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 47 == M2M-PCI64 (LANai7.0) LAN hacked 1Meg DMA controller */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},1*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,47,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 48 == Fiber interface */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_FIBER,MYRINET_BUS_FIBER,48,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 49 == M2M-PCI64 (LANai7.x) 4Meg dense chips */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,49,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 50 == M2L-PCI64 (LANai7.x) 4meg dense chips */
{ 0x030003A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,50,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 51 == M2M-PCI64A (LANai7.0) ASIC 2meg PROTOTYPE */
{ 0x032005A1,0x0700,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,51,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* 52 == M2L-PCI64A (LANai7.2) ASIC 4meg PROTOTYPE */
{ 0x032005A1,0x0702,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,52,0xFFFFFFFF,{0},0xFFFF,{0},0},

/* start adding in the max_lanai_speed */

/* 53 == M2M-PCI64A (LANai7.2) ASIC 2meg */
{ 0x033006a1,0x0702,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,53,0xFFFFFFFF,{0},67,{0},0},

/* 54 == M2L-PCI64A (LANai7.2) ASIC 2meg */
{ 0x033006a1,0x0702,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},2*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,54,0xFFFFFFFF,{0},67,{0},0},

/* 55 == M2L-PCI64A-4 (LANai7.2) ASIC 4meg */
{ 0x033006a1,0x0702,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,55,0xFFFFFFFF,{0},67,{0},0},

/* 56 == M2L-PCI64A-4 HP (LANai7.2) ASIC 4meg */
{ 0x033006a1,0x0702,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},4*1024*1024,{0},{0},
  0x00,MYRINET_BOARDTYPE_L5,MYRINET_BUS_PCI,56,0xFFFFFFFF,{0},67,{0},0},


/* LANai7 L7 clockvals
0x03000381  33MHz L7
0x03000391  50MHz L7
0x030003A1  66MHz L7
*/

};


struct names {
    char *name;
    int length;
    unsigned char id[6];
    int id_offset;
};

struct names boards[] =
{
    {0, 0, {0, 0, 0, 0}, 0},
	/* these exactly match the product codes */
	/* They should start '(' and end with ')' to ease recognition in the EEPROM */
    {"M2F-SBus32-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PMC32a-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

    {"M2M-PMC32-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-GSC32K-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-GSC32S-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-SBus32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 11 */
    {"FPGA-Node-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PMC32b-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-SBus32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

    {"M2F-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"F-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32L5-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PMC32c-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-GSC32H-%05d",  0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 21 */
    {"M2F-SBus32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-SBus32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

    {"M2M-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI32H-1meg-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-GSC32H-2meg-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-GSC32H-1meg-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI32H-2meg-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 31 */
    {"M2L-SW16H-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-SW16-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI32H-EISA-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2LM-SW16-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-SW16-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 36 */
    {"M2F-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2F-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PMC32b-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 41 */
    {"M2M-PMC32c-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI64X-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI64-2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64-2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

	/* 46 */
    {"Fiber Junk-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64-L7-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"Fiber Junk2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI64-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},

    {"M2M-PCI64Aproto-2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64Aproto-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2M-PCI64A-2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64A-2-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64A-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},
    {"M2L-PCI64A-4-%05d", 0, {0x00, 0x00, 0x00, 0x00}, 0},



	/* these are for legacy boards - do string matching */
    {"M2-SBus32-%05d", 4, {0x00, 0x60, 0xdd, 0x00}, 10000},
    {"M2F-SBus32-%05d", 4, {0x00, 0x60, 0xdd, 0xC0}, 10000},

    {"M2-PCI32-%05d", 4, {0x00, 0x60, 0xdd, 0x80}, 10000},
    {"M2F-PCI32-%05d", 4, {0x00, 0x60, 0xdd, 0xE0}, 10000},
    {"M2M-PCI32-%05d", 4, {0x00, 0x60, 0xdd, 0xF8}, 10000},

    {"M2M-PMC32-%05d", 4, {0x00, 0x60, 0xdd, 0xF0}, 10000},
    {"M2M-PMC32A-%05d", 4, {0x00, 0x60, 0xdd, 0x90}, 10000},

    {"(GSC1-%04d)\n", 4, {0x00, 0x01, 0x00, 0x00}, 0},
    {"(GSC2-%04d)\n", 4, {0x00, 0x02, 0x00, 0x00}, 0},
    {"M2F-GSC1.2-%05d", 4, {0x00, 0x03, 0x00, 0x00}, 10000},
    {"M2F-GSC32K-%05d", 4, {0x00, 0x04, 0x00, 0x00}, 10000},

    {"(LANai Test Fixture)", 6, {0x00, 0x60, 0xdd, 0x01, 0x86, 0x9f}, -1},

    {"", 0, {0, 0, 0, 0, 0, 0}, 0}
};

