/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#ifndef _gm_lanai_def_h_
#define _gm_lanai_def_h_

#define L4 0
#define L5 0
#define L6 0
#define L7 0
#define L8 0
#define L9 0

#if GM_LANAI_MAJOR_VERSION == 4
#undef L4
#define L4 1
#elif GM_LANAI_MAJOR_VERSION == 5
#undef L5
#define L5 1
#elif GM_LANAI_MAJOR_VERSION == 6
#undef L6
#define L6 1
#elif GM_LANAI_MAJOR_VERSION == 7
#undef L7
#define L7 1
#elif GM_LANAI_MAJOR_VERSION == 8
#define L8 1
#elif GM_LANAI_MAJOR_VERSION == 9
#undef L9
#define L9 1
#elif GM_LANAI_MAJOR_VERSION
#error GM_LANAI_MAJOR_VERSION not recognized
#else
#error GM_LANAI_MAJOR_VERSION not defined
#endif

/* Include the appropriate LANai definition header file */

#if L4
#include "lanai4_def.h"
#elif L5
#include "lanai5_def.h"
#elif L6
#include "lanai6_def.h"
#elif L7
#include "lanai7_def.h"
#elif L8
#include "lanai8_def.h"
#elif L9
#include "lanai9_def.h"
#endif

/* Define the fake DMA_INT_BIT for CPUs that don't define this already. */

#if L6 | L7
#define DMA_INT_BIT WAKE_INT_BIT
#elif L8 | L9
#define DMA_INT_BIT WAKE0_INT_BIT
#endif

/* Make sure we are using the correct compiler. */

#ifndef lanai			/* lanai-gcc OK for any lanai */
#  if L4 || L5 || L6
#    ifndef lanai3		/* lanai3-gcc OK for L[456] only */
#      error using wrong compiler
#    endif
#  elif L7 | L8
#    ifndef lanai7		/* lanai7-gcc OK for L[78] only */
#      error using wrong compiler
#    endif
#  else
#    error bad compiler for this version of LANai
#  endif
#endif

/* Define GM_DMA_GRANULARITY to reflect the hardware capabilities. */

#if L4
#define GM_DMA_GRANULARITY 4
#elif L5 
#define GM_DMA_GRANULARITY 8
#elif L6 | L7 | L8 | L9
#define GM_DMA_GRANULARITY 1
#else
#error Do not know GM_DMA_GRANULARITY
#endif
#if 1
#define GM_DMA_GRANULARITY_ROUNDUP (GM_DMA_GRANULARITY-1)
#else
/* for L4 to check the code with four words alignement assumptions */
#define GM_DMA_GRANULARITY_ROUNDUP 0
#endif

#endif /* _gm_lanai_def_h_ */
